/*********************************************************************/
/* from regdef.v by regdef2h auto-generated C-header file            */
/* please see the regdef.html file for detailed register description */
/*********************************************************************/

#ifndef __eplcn_regdef_h
#define __eplcn_regdef_h


/* ===================================================================== */

/* Area of EPLCNBASE */

/* ===================================================================== */


/* --------------------------------------------------------------------- */
/* Register AREA_EPLCN_XPEC_PROGRAM */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_AREA_EPLCN_XPEC_PROGRAM       0x00000000U

/* --------------------------------------------------------------------- */
/* Register AREA_EPLCN_TXAREABASE */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_AREA_EPLCN_TXAREABASE       0x00000004U

/* --------------------------------------------------------------------- */
/* Register EPLCN_TX_POINTER_ACTUAL */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_TX_POINTER_ACTUAL       0x00000004U

#define MSK_EPLCN_TX_POINTER_ACTUAL_VAL 0xffffffffU
#define SRT_EPLCN_TX_POINTER_ACTUAL_VAL 0

enum {
	BFW_EPLCN_TX_POINTER_ACTUAL_VAL = 32  /* [31:0] */
};

typedef struct EPLCN_TX_POINTER_ACTUAL_BIT_Ttag {
	unsigned int VAL : BFW_EPLCN_TX_POINTER_ACTUAL_VAL; /* actual pointer to ethernet data to transmit */
} EPLCN_TX_POINTER_ACTUAL_BIT_T;

typedef union {
	unsigned int                  val;
	EPLCN_TX_POINTER_ACTUAL_BIT_T bf;
} EPLCN_TX_POINTER_ACTUAL_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_TX_BYTES_LEFT_FOR_UTX */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_TX_BYTES_LEFT_FOR_UTX       0x00000008U

#define MSK_EPLCN_TX_BYTES_LEFT_FOR_UTX_VAL 0xffffffffU
#define SRT_EPLCN_TX_BYTES_LEFT_FOR_UTX_VAL 0

enum {
	BFW_EPLCN_TX_BYTES_LEFT_FOR_UTX_VAL = 32  /* [31:0] */
};

typedef struct EPLCN_TX_BYTES_LEFT_FOR_UTX_BIT_Ttag {
	unsigned int VAL : BFW_EPLCN_TX_BYTES_LEFT_FOR_UTX_VAL; /* number of bytes left to transmit to utx fifo */
} EPLCN_TX_BYTES_LEFT_FOR_UTX_BIT_T;

typedef union {
	unsigned int                      val;
	EPLCN_TX_BYTES_LEFT_FOR_UTX_BIT_T bf;
} EPLCN_TX_BYTES_LEFT_FOR_UTX_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_TX_BYTES_LEFT_FOR_DMA */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_TX_BYTES_LEFT_FOR_DMA       0x0000000CU

#define MSK_EPLCN_TX_BYTES_LEFT_FOR_DMA_VAL 0xffffffffU
#define SRT_EPLCN_TX_BYTES_LEFT_FOR_DMA_VAL 0

enum {
	BFW_EPLCN_TX_BYTES_LEFT_FOR_DMA_VAL = 32  /* [31:0] */
};

typedef struct EPLCN_TX_BYTES_LEFT_FOR_DMA_BIT_Ttag {
	unsigned int VAL : BFW_EPLCN_TX_BYTES_LEFT_FOR_DMA_VAL; /* number of bytes left for DMA */
} EPLCN_TX_BYTES_LEFT_FOR_DMA_BIT_T;

typedef union {
	unsigned int                      val;
	EPLCN_TX_BYTES_LEFT_FOR_DMA_BIT_T bf;
} EPLCN_TX_BYTES_LEFT_FOR_DMA_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_TX_RETRY */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_TX_RETRY       0x00000010U

#define MSK_EPLCN_TX_RETRY_CNT 0xffffffffU
#define SRT_EPLCN_TX_RETRY_CNT 0

enum {
	BFW_EPLCN_TX_RETRY_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_TX_RETRY_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_TX_RETRY_CNT; /* retry counter for transmission attempts */
} EPLCN_TX_RETRY_BIT_T;

typedef union {
	unsigned int         val;
	EPLCN_TX_RETRY_BIT_T bf;
} EPLCN_TX_RETRY_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_TX_BACKOFF_DELAY */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_TX_BACKOFF_DELAY       0x00000014U

#define MSK_EPLCN_TX_BACKOFF_DELAY_VAL 0xffffffffU
#define SRT_EPLCN_TX_BACKOFF_DELAY_VAL 0

enum {
	BFW_EPLCN_TX_BACKOFF_DELAY_VAL = 32  /* [31:0] */
};

typedef struct EPLCN_TX_BACKOFF_DELAY_BIT_Ttag {
	unsigned int VAL : BFW_EPLCN_TX_BACKOFF_DELAY_VAL; /* calculated back-off-delay */
} EPLCN_TX_BACKOFF_DELAY_BIT_T;

typedef union {
	unsigned int                 val;
	EPLCN_TX_BACKOFF_DELAY_BIT_T bf;
} EPLCN_TX_BACKOFF_DELAY_T;

/* --------------------------------------------------------------------- */
/* Register AREA_EPLCN_RXAREABASE */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_AREA_EPLCN_RXAREABASE       0x00000018U

/* --------------------------------------------------------------------- */
/* Register EPLCN_RX_DST_MAC_ADDRESS_LO */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_RX_DST_MAC_ADDRESS_LO       0x00000018U

#define MSK_EPLCN_RX_DST_MAC_ADDRESS_LO_INDIVIDUAL_OR_GROUP_ADDRESS  0x00000001U
#define SRT_EPLCN_RX_DST_MAC_ADDRESS_LO_INDIVIDUAL_OR_GROUP_ADDRESS  0
#define MSK_EPLCN_RX_DST_MAC_ADDRESS_LO_GLOBALLY_OR_LOCALLY_ADM_ADDR 0x00000002U
#define SRT_EPLCN_RX_DST_MAC_ADDRESS_LO_GLOBALLY_OR_LOCALLY_ADM_ADDR 1
#define MSK_EPLCN_RX_DST_MAC_ADDRESS_LO_MAC_ADDR_LO                  0xfffffffcU
#define SRT_EPLCN_RX_DST_MAC_ADDRESS_LO_MAC_ADDR_LO                  2

enum {
	BFW_EPLCN_RX_DST_MAC_ADDRESS_LO_INDIVIDUAL_OR_GROUP_ADDRESS  = 1,  /* [0] */
	BFW_EPLCN_RX_DST_MAC_ADDRESS_LO_GLOBALLY_OR_LOCALLY_ADM_ADDR = 1,  /* [1] */
	BFW_EPLCN_RX_DST_MAC_ADDRESS_LO_MAC_ADDR_LO                  = 30  /* [31:2] */
};

typedef struct EPLCN_RX_DST_MAC_ADDRESS_LO_BIT_Ttag {
	unsigned int INDIVIDUAL_OR_GROUP_ADDRESS  : BFW_EPLCN_RX_DST_MAC_ADDRESS_LO_INDIVIDUAL_OR_GROUP_ADDRESS;  /* individual or group address              */
	unsigned int GLOBALLY_OR_LOCALLY_ADM_ADDR : BFW_EPLCN_RX_DST_MAC_ADDRESS_LO_GLOBALLY_OR_LOCALLY_ADM_ADDR; /* globally or locally administered address */
	unsigned int MAC_ADDR_LO                  : BFW_EPLCN_RX_DST_MAC_ADDRESS_LO_MAC_ADDR_LO;                  /* MAC address bits 31..2                   */
} EPLCN_RX_DST_MAC_ADDRESS_LO_BIT_T;

typedef union {
	unsigned int                      val;
	EPLCN_RX_DST_MAC_ADDRESS_LO_BIT_T bf;
} EPLCN_RX_DST_MAC_ADDRESS_LO_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_RX_DST_MAC_ADDRESS_HI */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_RX_DST_MAC_ADDRESS_HI       0x0000001CU

#define MSK_EPLCN_RX_DST_MAC_ADDRESS_HI_MAC_ADDR_HI 0x0000ffffU
#define SRT_EPLCN_RX_DST_MAC_ADDRESS_HI_MAC_ADDR_HI 0

enum {
	BFW_EPLCN_RX_DST_MAC_ADDRESS_HI_MAC_ADDR_HI = 16, /* [15:0] */
	BFW_EPLCN_RX_DST_MAC_ADDRESS_HI_reserved1   = 16  /* [31:16] */
};

typedef struct EPLCN_RX_DST_MAC_ADDRESS_HI_BIT_Ttag {
	unsigned int MAC_ADDR_HI : BFW_EPLCN_RX_DST_MAC_ADDRESS_HI_MAC_ADDR_HI; /* MAC address bits 47..32 */
	unsigned int reserved1   : BFW_EPLCN_RX_DST_MAC_ADDRESS_HI_reserved1;   /*  reserved               */
} EPLCN_RX_DST_MAC_ADDRESS_HI_BIT_T;

typedef union {
	unsigned int                      val;
	EPLCN_RX_DST_MAC_ADDRESS_HI_BIT_T bf;
} EPLCN_RX_DST_MAC_ADDRESS_HI_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_RX_SRC_MAC_ADDRESS_LO */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_RX_SRC_MAC_ADDRESS_LO       0x00000020U

#define MSK_EPLCN_RX_SRC_MAC_ADDRESS_LO_INDIVIDUAL_OR_GROUP_ADDRESS  0x00000001U
#define SRT_EPLCN_RX_SRC_MAC_ADDRESS_LO_INDIVIDUAL_OR_GROUP_ADDRESS  0
#define MSK_EPLCN_RX_SRC_MAC_ADDRESS_LO_GLOBALLY_OR_LOCALLY_ADM_ADDR 0x00000002U
#define SRT_EPLCN_RX_SRC_MAC_ADDRESS_LO_GLOBALLY_OR_LOCALLY_ADM_ADDR 1
#define MSK_EPLCN_RX_SRC_MAC_ADDRESS_LO_MAC_ADDR_LO                  0xfffffffcU
#define SRT_EPLCN_RX_SRC_MAC_ADDRESS_LO_MAC_ADDR_LO                  2

enum {
	BFW_EPLCN_RX_SRC_MAC_ADDRESS_LO_INDIVIDUAL_OR_GROUP_ADDRESS  = 1,  /* [0] */
	BFW_EPLCN_RX_SRC_MAC_ADDRESS_LO_GLOBALLY_OR_LOCALLY_ADM_ADDR = 1,  /* [1] */
	BFW_EPLCN_RX_SRC_MAC_ADDRESS_LO_MAC_ADDR_LO                  = 30  /* [31:2] */
};

typedef struct EPLCN_RX_SRC_MAC_ADDRESS_LO_BIT_Ttag {
	unsigned int INDIVIDUAL_OR_GROUP_ADDRESS  : BFW_EPLCN_RX_SRC_MAC_ADDRESS_LO_INDIVIDUAL_OR_GROUP_ADDRESS;  /* individual or group address              */
	unsigned int GLOBALLY_OR_LOCALLY_ADM_ADDR : BFW_EPLCN_RX_SRC_MAC_ADDRESS_LO_GLOBALLY_OR_LOCALLY_ADM_ADDR; /* globally or locally administered address */
	unsigned int MAC_ADDR_LO                  : BFW_EPLCN_RX_SRC_MAC_ADDRESS_LO_MAC_ADDR_LO;                  /* MAC address bits 31..2                   */
} EPLCN_RX_SRC_MAC_ADDRESS_LO_BIT_T;

typedef union {
	unsigned int                      val;
	EPLCN_RX_SRC_MAC_ADDRESS_LO_BIT_T bf;
} EPLCN_RX_SRC_MAC_ADDRESS_LO_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_RX_SRC_MAC_ADDRESS_HI */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_RX_SRC_MAC_ADDRESS_HI       0x00000024U

#define MSK_EPLCN_RX_SRC_MAC_ADDRESS_HI_MAC_ADDR_HI 0x0000ffffU
#define SRT_EPLCN_RX_SRC_MAC_ADDRESS_HI_MAC_ADDR_HI 0

enum {
	BFW_EPLCN_RX_SRC_MAC_ADDRESS_HI_MAC_ADDR_HI = 16, /* [15:0] */
	BFW_EPLCN_RX_SRC_MAC_ADDRESS_HI_reserved1   = 16  /* [31:16] */
};

typedef struct EPLCN_RX_SRC_MAC_ADDRESS_HI_BIT_Ttag {
	unsigned int MAC_ADDR_HI : BFW_EPLCN_RX_SRC_MAC_ADDRESS_HI_MAC_ADDR_HI; /* MAC address bits 47..32 */
	unsigned int reserved1   : BFW_EPLCN_RX_SRC_MAC_ADDRESS_HI_reserved1;   /*  reserved               */
} EPLCN_RX_SRC_MAC_ADDRESS_HI_BIT_T;

typedef union {
	unsigned int                      val;
	EPLCN_RX_SRC_MAC_ADDRESS_HI_BIT_T bf;
} EPLCN_RX_SRC_MAC_ADDRESS_HI_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_RX_ETH_LT */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_RX_ETH_LT       0x00000028U

#define MSK_EPLCN_RX_ETH_LT_VAL  0x0000ffffU
#define SRT_EPLCN_RX_ETH_LT_VAL  0
#define MSK_EPLCN_RX_ETH_LT_RES1 0xffff0000U
#define SRT_EPLCN_RX_ETH_LT_RES1 16

enum {
	BFW_EPLCN_RX_ETH_LT_VAL  = 16, /* [15:0] */
	BFW_EPLCN_RX_ETH_LT_RES1 = 16  /* [31:16] */
};

typedef struct EPLCN_RX_ETH_LT_BIT_Ttag {
	unsigned int VAL  : BFW_EPLCN_RX_ETH_LT_VAL;  /* received type/len field of current Ethernet frame */
	unsigned int RES1 : BFW_EPLCN_RX_ETH_LT_RES1; /* res                                               */
} EPLCN_RX_ETH_LT_BIT_T;

typedef union {
	unsigned int          val;
	EPLCN_RX_ETH_LT_BIT_T bf;
} EPLCN_RX_ETH_LT_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_RX_EPL_FRAME_MESSAGE_TYPE */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_RX_EPL_FRAME_MESSAGE_TYPE       0x0000002CU

#define MSK_EPLCN_RX_EPL_FRAME_MESSAGE_TYPE_VAL  0x00000007U
#define SRT_EPLCN_RX_EPL_FRAME_MESSAGE_TYPE_VAL  0
#define MSK_EPLCN_RX_EPL_FRAME_MESSAGE_TYPE_RES1 0xfffffff8U
#define SRT_EPLCN_RX_EPL_FRAME_MESSAGE_TYPE_RES1 3

enum {
	BFW_EPLCN_RX_EPL_FRAME_MESSAGE_TYPE_VAL  = 3,  /* [2:0] */
	BFW_EPLCN_RX_EPL_FRAME_MESSAGE_TYPE_RES1 = 29  /* [31:3] */
};

typedef struct EPLCN_RX_EPL_FRAME_MESSAGE_TYPE_BIT_Ttag {
	unsigned int VAL  : BFW_EPLCN_RX_EPL_FRAME_MESSAGE_TYPE_VAL;  /* message type of current EPL frame */
	unsigned int RES1 : BFW_EPLCN_RX_EPL_FRAME_MESSAGE_TYPE_RES1; /* res                               */
} EPLCN_RX_EPL_FRAME_MESSAGE_TYPE_BIT_T;

typedef union {
	unsigned int                          val;
	EPLCN_RX_EPL_FRAME_MESSAGE_TYPE_BIT_T bf;
} EPLCN_RX_EPL_FRAME_MESSAGE_TYPE_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_RX_EPL_FRAME_DST */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_RX_EPL_FRAME_DST       0x00000030U

#define MSK_EPLCN_RX_EPL_FRAME_DST_VAL  0x000000ffU
#define SRT_EPLCN_RX_EPL_FRAME_DST_VAL  0
#define MSK_EPLCN_RX_EPL_FRAME_DST_RES1 0xffffff00U
#define SRT_EPLCN_RX_EPL_FRAME_DST_RES1 8

enum {
	BFW_EPLCN_RX_EPL_FRAME_DST_VAL  = 8,  /* [7:0] */
	BFW_EPLCN_RX_EPL_FRAME_DST_RES1 = 24  /* [31:8] */
};

typedef struct EPLCN_RX_EPL_FRAME_DST_BIT_Ttag {
	unsigned int VAL  : BFW_EPLCN_RX_EPL_FRAME_DST_VAL;  /* destination of current EPL frame */
	unsigned int RES1 : BFW_EPLCN_RX_EPL_FRAME_DST_RES1; /* res                              */
} EPLCN_RX_EPL_FRAME_DST_BIT_T;

typedef union {
	unsigned int                 val;
	EPLCN_RX_EPL_FRAME_DST_BIT_T bf;
} EPLCN_RX_EPL_FRAME_DST_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_RX_EPL_FRAME_SRC */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_RX_EPL_FRAME_SRC       0x00000034U

#define MSK_EPLCN_RX_EPL_FRAME_SRC_VAL  0x000000ffU
#define SRT_EPLCN_RX_EPL_FRAME_SRC_VAL  0
#define MSK_EPLCN_RX_EPL_FRAME_SRC_RES1 0xffffff00U
#define SRT_EPLCN_RX_EPL_FRAME_SRC_RES1 8

enum {
	BFW_EPLCN_RX_EPL_FRAME_SRC_VAL  = 8,  /* [7:0] */
	BFW_EPLCN_RX_EPL_FRAME_SRC_RES1 = 24  /* [31:8] */
};

typedef struct EPLCN_RX_EPL_FRAME_SRC_BIT_Ttag {
	unsigned int VAL  : BFW_EPLCN_RX_EPL_FRAME_SRC_VAL;  /* source of current EPL frame */
	unsigned int RES1 : BFW_EPLCN_RX_EPL_FRAME_SRC_RES1; /* res                         */
} EPLCN_RX_EPL_FRAME_SRC_BIT_T;

typedef union {
	unsigned int                 val;
	EPLCN_RX_EPL_FRAME_SRC_BIT_T bf;
} EPLCN_RX_EPL_FRAME_SRC_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_RX_TIMESTAMP_NS */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_RX_TIMESTAMP_NS       0x00000038U

#define MSK_EPLCN_RX_TIMESTAMP_NS_VAL 0xffffffffU
#define SRT_EPLCN_RX_TIMESTAMP_NS_VAL 0

enum {
	BFW_EPLCN_RX_TIMESTAMP_NS_VAL = 32  /* [31:0] */
};

typedef struct EPLCN_RX_TIMESTAMP_NS_BIT_Ttag {
	unsigned int VAL : BFW_EPLCN_RX_TIMESTAMP_NS_VAL; /* receive timestamp ns of incoming packet */
} EPLCN_RX_TIMESTAMP_NS_BIT_T;

typedef union {
	unsigned int                val;
	EPLCN_RX_TIMESTAMP_NS_BIT_T bf;
} EPLCN_RX_TIMESTAMP_NS_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_RX_TIMESTAMP_S */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_RX_TIMESTAMP_S       0x0000003CU

#define MSK_EPLCN_RX_TIMESTAMP_S_VAL 0xffffffffU
#define SRT_EPLCN_RX_TIMESTAMP_S_VAL 0

enum {
	BFW_EPLCN_RX_TIMESTAMP_S_VAL = 32  /* [31:0] */
};

typedef struct EPLCN_RX_TIMESTAMP_S_BIT_Ttag {
	unsigned int VAL : BFW_EPLCN_RX_TIMESTAMP_S_VAL; /* receive timestamp s of incoming packet */
} EPLCN_RX_TIMESTAMP_S_BIT_T;

typedef union {
	unsigned int               val;
	EPLCN_RX_TIMESTAMP_S_BIT_T bf;
} EPLCN_RX_TIMESTAMP_S_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_RX_POINTER_ACTUAL */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_RX_POINTER_ACTUAL       0x00000040U

#define MSK_EPLCN_RX_POINTER_ACTUAL_VAL 0xffffffffU
#define SRT_EPLCN_RX_POINTER_ACTUAL_VAL 0

enum {
	BFW_EPLCN_RX_POINTER_ACTUAL_VAL = 32  /* [31:0] */
};

typedef struct EPLCN_RX_POINTER_ACTUAL_BIT_Ttag {
	unsigned int VAL : BFW_EPLCN_RX_POINTER_ACTUAL_VAL; /* data buffer run pointer of actual received ethernet packet */
} EPLCN_RX_POINTER_ACTUAL_BIT_T;

typedef union {
	unsigned int                  val;
	EPLCN_RX_POINTER_ACTUAL_BIT_T bf;
} EPLCN_RX_POINTER_ACTUAL_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_RX_WORKING */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_RX_WORKING       0x00000044U

#define MSK_EPLCN_RX_WORKING_VAL 0xffffffffU
#define SRT_EPLCN_RX_WORKING_VAL 0

enum {
	BFW_EPLCN_RX_WORKING_VAL = 32  /* [31:0] */
};

typedef struct EPLCN_RX_WORKING_BIT_Ttag {
	unsigned int VAL : BFW_EPLCN_RX_WORKING_VAL; /* receive help working variable */
} EPLCN_RX_WORKING_BIT_T;

typedef union {
	unsigned int           val;
	EPLCN_RX_WORKING_BIT_T bf;
} EPLCN_RX_WORKING_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_RX_FRAME_FIN_OK_EPL_JUMP_LABEL */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_RX_FRAME_FIN_OK_EPL_JUMP_LABEL       0x00000048U

#define MSK_EPLCN_RX_FRAME_FIN_OK_EPL_JUMP_LABEL_VAL 0xffffffffU
#define SRT_EPLCN_RX_FRAME_FIN_OK_EPL_JUMP_LABEL_VAL 0

enum {
	BFW_EPLCN_RX_FRAME_FIN_OK_EPL_JUMP_LABEL_VAL = 32  /* [31:0] */
};

typedef struct EPLCN_RX_FRAME_FIN_OK_EPL_JUMP_LABEL_BIT_Ttag {
	unsigned int VAL : BFW_EPLCN_RX_FRAME_FIN_OK_EPL_JUMP_LABEL_VAL; /* jump label where after rx fraem finished to jump */
} EPLCN_RX_FRAME_FIN_OK_EPL_JUMP_LABEL_BIT_T;

typedef union {
	unsigned int                               val;
	EPLCN_RX_FRAME_FIN_OK_EPL_JUMP_LABEL_BIT_T bf;
} EPLCN_RX_FRAME_FIN_OK_EPL_JUMP_LABEL_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_DMA0_CFG */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_DMA0_CFG       0x0000004CU

#define MSK_EPLCN_DMA0_CFG_VAL 0xffffffffU
#define SRT_EPLCN_DMA0_CFG_VAL 0

enum {
	BFW_EPLCN_DMA0_CFG_VAL = 32  /* [31:0] */
};

typedef struct EPLCN_DMA0_CFG_BIT_Ttag {
	unsigned int VAL : BFW_EPLCN_DMA0_CFG_VAL; /* dma enable mask for dma0 rx buf1 -> ARM */
} EPLCN_DMA0_CFG_BIT_T;

typedef union {
	unsigned int         val;
	EPLCN_DMA0_CFG_BIT_T bf;
} EPLCN_DMA0_CFG_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_DMA1_CFG */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_DMA1_CFG       0x00000050U

#define MSK_EPLCN_DMA1_CFG_VAL 0xffffffffU
#define SRT_EPLCN_DMA1_CFG_VAL 0

enum {
	BFW_EPLCN_DMA1_CFG_VAL = 32  /* [31:0] */
};

typedef struct EPLCN_DMA1_CFG_BIT_Ttag {
	unsigned int VAL : BFW_EPLCN_DMA1_CFG_VAL; /* dma enable mask for dma1 rx buf2 -> ARM */
} EPLCN_DMA1_CFG_BIT_T;

typedef union {
	unsigned int         val;
	EPLCN_DMA1_CFG_BIT_T bf;
} EPLCN_DMA1_CFG_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_FLASH_FREQ_OF_LINK_ACT_TEMP */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_FLASH_FREQ_OF_LINK_ACT_TEMP       0x00000054U

#define MSK_EPLCN_FLASH_FREQ_OF_LINK_ACT_TEMP_VAL_PORT_0 0x0000ffffU
#define SRT_EPLCN_FLASH_FREQ_OF_LINK_ACT_TEMP_VAL_PORT_0 0
#define MSK_EPLCN_FLASH_FREQ_OF_LINK_ACT_TEMP_VAL_PORT_1 0xffff0000U
#define SRT_EPLCN_FLASH_FREQ_OF_LINK_ACT_TEMP_VAL_PORT_1 16

enum {
	BFW_EPLCN_FLASH_FREQ_OF_LINK_ACT_TEMP_VAL_PORT_0 = 16, /* [15:0] */
	BFW_EPLCN_FLASH_FREQ_OF_LINK_ACT_TEMP_VAL_PORT_1 = 16  /* [31:16] */
};

typedef struct EPLCN_FLASH_FREQ_OF_LINK_ACT_TEMP_BIT_Ttag {
	unsigned int VAL_PORT_0 : BFW_EPLCN_FLASH_FREQ_OF_LINK_ACT_TEMP_VAL_PORT_0; /* temporary value for port 0 */
	unsigned int VAL_PORT_1 : BFW_EPLCN_FLASH_FREQ_OF_LINK_ACT_TEMP_VAL_PORT_1; /* temporary value for port 1 */
} EPLCN_FLASH_FREQ_OF_LINK_ACT_TEMP_BIT_T;

typedef union {
	unsigned int                            val;
	EPLCN_FLASH_FREQ_OF_LINK_ACT_TEMP_BIT_T bf;
} EPLCN_FLASH_FREQ_OF_LINK_ACT_TEMP_T;

/* --------------------------------------------------------------------- */
/* Register AREA_EPLCN_CONFIG_AREA_BASE */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_AREA_EPLCN_CONFIG_AREA_BASE       0x00000058U

/* --------------------------------------------------------------------- */
/* Register EPLCN_GEN_SOC_RCVD_TRIGGER_OE */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_GEN_SOC_RCVD_TRIGGER_OE       0x00000058U

#define MSK_EPLCN_GEN_SOC_RCVD_TRIGGER_OE_VAL  0x00000001U
#define SRT_EPLCN_GEN_SOC_RCVD_TRIGGER_OE_VAL  0
#define MSK_EPLCN_GEN_SOC_RCVD_TRIGGER_OE_RES1 0xfffffffeU
#define SRT_EPLCN_GEN_SOC_RCVD_TRIGGER_OE_RES1 1

enum {
	BFW_EPLCN_GEN_SOC_RCVD_TRIGGER_OE_VAL  = 1,  /* [0] */
	BFW_EPLCN_GEN_SOC_RCVD_TRIGGER_OE_RES1 = 31  /* [31:1] */
};

typedef struct EPLCN_GEN_SOC_RCVD_TRIGGER_OE_BIT_Ttag {
	unsigned int VAL  : BFW_EPLCN_GEN_SOC_RCVD_TRIGGER_OE_VAL;  /* 1/0: SoC received trigger (xm3.io0) output enabled/disabled, must be set before starting xPEC */
	unsigned int RES1 : BFW_EPLCN_GEN_SOC_RCVD_TRIGGER_OE_RES1; /* reserved                                                                                      */
} EPLCN_GEN_SOC_RCVD_TRIGGER_OE_BIT_T;

typedef union {
	unsigned int                        val;
	EPLCN_GEN_SOC_RCVD_TRIGGER_OE_BIT_T bf;
} EPLCN_GEN_SOC_RCVD_TRIGGER_OE_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_GEN_SOC_RCVD_TRIGGER_POLARITY */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_GEN_SOC_RCVD_TRIGGER_POLARITY       0x0000005CU

#define MSK_EPLCN_GEN_SOC_RCVD_TRIGGER_POLARITY_VAL  0x00000001U
#define SRT_EPLCN_GEN_SOC_RCVD_TRIGGER_POLARITY_VAL  0
#define MSK_EPLCN_GEN_SOC_RCVD_TRIGGER_POLARITY_RES1 0xfffffffeU
#define SRT_EPLCN_GEN_SOC_RCVD_TRIGGER_POLARITY_RES1 1

enum {
	BFW_EPLCN_GEN_SOC_RCVD_TRIGGER_POLARITY_VAL  = 1,  /* [0] */
	BFW_EPLCN_GEN_SOC_RCVD_TRIGGER_POLARITY_RES1 = 31  /* [31:1] */
};

typedef struct EPLCN_GEN_SOC_RCVD_TRIGGER_POLARITY_BIT_Ttag {
	unsigned int VAL  : BFW_EPLCN_GEN_SOC_RCVD_TRIGGER_POLARITY_VAL;  /* 1/0: high/low polarity of SoC received trigger (only valid if GEN_SOC_RCVD_TRIGGER_OE==1), must be set before starting xPEC */
	unsigned int RES1 : BFW_EPLCN_GEN_SOC_RCVD_TRIGGER_POLARITY_RES1; /* reserved                                                                                                                    */
} EPLCN_GEN_SOC_RCVD_TRIGGER_POLARITY_BIT_T;

typedef union {
	unsigned int                              val;
	EPLCN_GEN_SOC_RCVD_TRIGGER_POLARITY_BIT_T bf;
} EPLCN_GEN_SOC_RCVD_TRIGGER_POLARITY_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_SOC_TRIGGER_DELAY */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_SOC_TRIGGER_DELAY       0x00000060U

#define MSK_EPLCN_SOC_TRIGGER_DELAY_VAL_IN_CC 0xffffffffU
#define SRT_EPLCN_SOC_TRIGGER_DELAY_VAL_IN_CC 0

enum {
	BFW_EPLCN_SOC_TRIGGER_DELAY_VAL_IN_CC = 32  /* [31:0] */
};

typedef struct EPLCN_SOC_TRIGGER_DELAY_BIT_Ttag {
	unsigned int VAL_IN_CC : BFW_EPLCN_SOC_TRIGGER_DELAY_VAL_IN_CC; /* SoC received trigger delay in clock cycles, 0: disabled (triggered directly after reception of SoC) */
} EPLCN_SOC_TRIGGER_DELAY_BIT_T;

typedef union {
	unsigned int                  val;
	EPLCN_SOC_TRIGGER_DELAY_BIT_T bf;
} EPLCN_SOC_TRIGGER_DELAY_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_SOC_TRIGGER_LENGTH */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_SOC_TRIGGER_LENGTH       0x00000064U

#define MSK_EPLCN_SOC_TRIGGER_LENGTH_VAL_IN_CC 0xffffffffU
#define SRT_EPLCN_SOC_TRIGGER_LENGTH_VAL_IN_CC 0

enum {
	BFW_EPLCN_SOC_TRIGGER_LENGTH_VAL_IN_CC = 32  /* [31:0] */
};

typedef struct EPLCN_SOC_TRIGGER_LENGTH_BIT_Ttag {
	unsigned int VAL_IN_CC : BFW_EPLCN_SOC_TRIGGER_LENGTH_VAL_IN_CC; /* SoC received trigger length in clock cycles, 0: invalid */
} EPLCN_SOC_TRIGGER_LENGTH_BIT_T;

typedef union {
	unsigned int                   val;
	EPLCN_SOC_TRIGGER_LENGTH_BIT_T bf;
} EPLCN_SOC_TRIGGER_LENGTH_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_FLASH_FREQ_OF_LINK_ACT_LED */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_FLASH_FREQ_OF_LINK_ACT_LED       0x00000068U

#define MSK_EPLCN_FLASH_FREQ_OF_LINK_ACT_LED_VAL_IN_CC 0xffffffffU
#define SRT_EPLCN_FLASH_FREQ_OF_LINK_ACT_LED_VAL_IN_CC 0

enum {
	BFW_EPLCN_FLASH_FREQ_OF_LINK_ACT_LED_VAL_IN_CC = 32  /* [31:0] */
};

typedef struct EPLCN_FLASH_FREQ_OF_LINK_ACT_LED_BIT_Ttag {
	unsigned int VAL_IN_CC : BFW_EPLCN_FLASH_FREQ_OF_LINK_ACT_LED_VAL_IN_CC; /* value in clock cycles */
} EPLCN_FLASH_FREQ_OF_LINK_ACT_LED_BIT_T;

typedef union {
	unsigned int                           val;
	EPLCN_FLASH_FREQ_OF_LINK_ACT_LED_BIT_T bf;
} EPLCN_FLASH_FREQ_OF_LINK_ACT_LED_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_COL_LED_EN */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_COL_LED_EN       0x0000006CU

#define MSK_EPLCN_COL_LED_EN_VAL  0x00000001U
#define SRT_EPLCN_COL_LED_EN_VAL  0
#define MSK_EPLCN_COL_LED_EN_RES1 0xfffffffeU
#define SRT_EPLCN_COL_LED_EN_RES1 1

enum {
	BFW_EPLCN_COL_LED_EN_VAL  = 1,  /* [0] */
	BFW_EPLCN_COL_LED_EN_RES1 = 31  /* [31:1] */
};

typedef struct EPLCN_COL_LED_EN_BIT_Ttag {
	unsigned int VAL  : BFW_EPLCN_COL_LED_EN_VAL;  /* 1/0: collision LED enabled/disabled */
	unsigned int RES1 : BFW_EPLCN_COL_LED_EN_RES1; /* reserved                            */
} EPLCN_COL_LED_EN_BIT_T;

typedef union {
	unsigned int           val;
	EPLCN_COL_LED_EN_BIT_T bf;
} EPLCN_COL_LED_EN_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_FLASH_FREQ_OF_COL_LED */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_FLASH_FREQ_OF_COL_LED       0x00000070U

#define MSK_EPLCN_FLASH_FREQ_OF_COL_LED_VAL_IN_CC 0xffffffffU
#define SRT_EPLCN_FLASH_FREQ_OF_COL_LED_VAL_IN_CC 0

enum {
	BFW_EPLCN_FLASH_FREQ_OF_COL_LED_VAL_IN_CC = 32  /* [31:0] */
};

typedef struct EPLCN_FLASH_FREQ_OF_COL_LED_BIT_Ttag {
	unsigned int VAL_IN_CC : BFW_EPLCN_FLASH_FREQ_OF_COL_LED_VAL_IN_CC; /* value in clock cycles */
} EPLCN_FLASH_FREQ_OF_COL_LED_BIT_T;

typedef union {
	unsigned int                      val;
	EPLCN_FLASH_FREQ_OF_COL_LED_BIT_T bf;
} EPLCN_FLASH_FREQ_OF_COL_LED_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_INTERRUPTS_ENABLE_IND_HI */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_INTERRUPTS_ENABLE_IND_HI       0x00000074U

#define MSK_EPLCN_INTERRUPTS_ENABLE_IND_HI_VAL  0x00000001U
#define SRT_EPLCN_INTERRUPTS_ENABLE_IND_HI_VAL  0
#define MSK_EPLCN_INTERRUPTS_ENABLE_IND_HI_RES1 0xfffffffeU
#define SRT_EPLCN_INTERRUPTS_ENABLE_IND_HI_RES1 1

enum {
	BFW_EPLCN_INTERRUPTS_ENABLE_IND_HI_VAL  = 1,  /* [0] */
	BFW_EPLCN_INTERRUPTS_ENABLE_IND_HI_RES1 = 31  /* [31:1] */
};

typedef struct EPLCN_INTERRUPTS_ENABLE_IND_HI_BIT_Ttag {
	unsigned int VAL  : BFW_EPLCN_INTERRUPTS_ENABLE_IND_HI_VAL;  /* enable indication hi event     */
	unsigned int RES1 : BFW_EPLCN_INTERRUPTS_ENABLE_IND_HI_RES1; /* reserved, shall be set to zero */
} EPLCN_INTERRUPTS_ENABLE_IND_HI_BIT_T;

typedef union {
	unsigned int                         val;
	EPLCN_INTERRUPTS_ENABLE_IND_HI_BIT_T bf;
} EPLCN_INTERRUPTS_ENABLE_IND_HI_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_INTERRUPTS_ENABLE_IND_LO */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_INTERRUPTS_ENABLE_IND_LO       0x00000078U

#define MSK_EPLCN_INTERRUPTS_ENABLE_IND_LO_RES1 0x00000001U
#define SRT_EPLCN_INTERRUPTS_ENABLE_IND_LO_RES1 0
#define MSK_EPLCN_INTERRUPTS_ENABLE_IND_LO_VAL  0x00000002U
#define SRT_EPLCN_INTERRUPTS_ENABLE_IND_LO_VAL  1
#define MSK_EPLCN_INTERRUPTS_ENABLE_IND_LO_RES2 0xfffffffcU
#define SRT_EPLCN_INTERRUPTS_ENABLE_IND_LO_RES2 2

enum {
	BFW_EPLCN_INTERRUPTS_ENABLE_IND_LO_RES1 = 1,  /* [0] */
	BFW_EPLCN_INTERRUPTS_ENABLE_IND_LO_VAL  = 1,  /* [1] */
	BFW_EPLCN_INTERRUPTS_ENABLE_IND_LO_RES2 = 30  /* [31:2] */
};

typedef struct EPLCN_INTERRUPTS_ENABLE_IND_LO_BIT_Ttag {
	unsigned int RES1 : BFW_EPLCN_INTERRUPTS_ENABLE_IND_LO_RES1; /* reserved, shall be set to zero */
	unsigned int VAL  : BFW_EPLCN_INTERRUPTS_ENABLE_IND_LO_VAL;  /* enable indication lo event     */
	unsigned int RES2 : BFW_EPLCN_INTERRUPTS_ENABLE_IND_LO_RES2; /* reserved, shall be set to zero */
} EPLCN_INTERRUPTS_ENABLE_IND_LO_BIT_T;

typedef union {
	unsigned int                         val;
	EPLCN_INTERRUPTS_ENABLE_IND_LO_BIT_T bf;
} EPLCN_INTERRUPTS_ENABLE_IND_LO_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_INTERRUPTS_ENABLE_CON_HI */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_INTERRUPTS_ENABLE_CON_HI       0x0000007CU

#define MSK_EPLCN_INTERRUPTS_ENABLE_CON_HI_RES1 0x00000003U
#define SRT_EPLCN_INTERRUPTS_ENABLE_CON_HI_RES1 0
#define MSK_EPLCN_INTERRUPTS_ENABLE_CON_HI_VAL  0x00000004U
#define SRT_EPLCN_INTERRUPTS_ENABLE_CON_HI_VAL  2
#define MSK_EPLCN_INTERRUPTS_ENABLE_CON_HI_RES2 0xfffffff8U
#define SRT_EPLCN_INTERRUPTS_ENABLE_CON_HI_RES2 3

enum {
	BFW_EPLCN_INTERRUPTS_ENABLE_CON_HI_RES1 = 2,  /* [1:0] */
	BFW_EPLCN_INTERRUPTS_ENABLE_CON_HI_VAL  = 1,  /* [2] */
	BFW_EPLCN_INTERRUPTS_ENABLE_CON_HI_RES2 = 29  /* [31:3] */
};

typedef struct EPLCN_INTERRUPTS_ENABLE_CON_HI_BIT_Ttag {
	unsigned int RES1 : BFW_EPLCN_INTERRUPTS_ENABLE_CON_HI_RES1; /* reserved, shall be set to zero */
	unsigned int VAL  : BFW_EPLCN_INTERRUPTS_ENABLE_CON_HI_VAL;  /* enable confirmation hi event   */
	unsigned int RES2 : BFW_EPLCN_INTERRUPTS_ENABLE_CON_HI_RES2; /* reserved, shall be set to zero */
} EPLCN_INTERRUPTS_ENABLE_CON_HI_BIT_T;

typedef union {
	unsigned int                         val;
	EPLCN_INTERRUPTS_ENABLE_CON_HI_BIT_T bf;
} EPLCN_INTERRUPTS_ENABLE_CON_HI_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_INTERRUPTS_ENABLE_CON_LO */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_INTERRUPTS_ENABLE_CON_LO       0x00000080U

#define MSK_EPLCN_INTERRUPTS_ENABLE_CON_LO_RES1 0x00000007U
#define SRT_EPLCN_INTERRUPTS_ENABLE_CON_LO_RES1 0
#define MSK_EPLCN_INTERRUPTS_ENABLE_CON_LO_VAL  0x00000008U
#define SRT_EPLCN_INTERRUPTS_ENABLE_CON_LO_VAL  3
#define MSK_EPLCN_INTERRUPTS_ENABLE_CON_LO_RES2 0xfffffff0U
#define SRT_EPLCN_INTERRUPTS_ENABLE_CON_LO_RES2 4

enum {
	BFW_EPLCN_INTERRUPTS_ENABLE_CON_LO_RES1 = 3,  /* [2:0] */
	BFW_EPLCN_INTERRUPTS_ENABLE_CON_LO_VAL  = 1,  /* [3] */
	BFW_EPLCN_INTERRUPTS_ENABLE_CON_LO_RES2 = 28  /* [31:4] */
};

typedef struct EPLCN_INTERRUPTS_ENABLE_CON_LO_BIT_Ttag {
	unsigned int RES1 : BFW_EPLCN_INTERRUPTS_ENABLE_CON_LO_RES1; /* reserved, shall be set to zero */
	unsigned int VAL  : BFW_EPLCN_INTERRUPTS_ENABLE_CON_LO_VAL;  /* enable confirmation lo event   */
	unsigned int RES2 : BFW_EPLCN_INTERRUPTS_ENABLE_CON_LO_RES2; /* reserved, shall be set to zero */
} EPLCN_INTERRUPTS_ENABLE_CON_LO_BIT_T;

typedef union {
	unsigned int                         val;
	EPLCN_INTERRUPTS_ENABLE_CON_LO_BIT_T bf;
} EPLCN_INTERRUPTS_ENABLE_CON_LO_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_INTERRUPTS_ENABLE_COL */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_INTERRUPTS_ENABLE_COL       0x00000084U

#define MSK_EPLCN_INTERRUPTS_ENABLE_COL_RES1 0x0000001fU
#define SRT_EPLCN_INTERRUPTS_ENABLE_COL_RES1 0
#define MSK_EPLCN_INTERRUPTS_ENABLE_COL_VAL  0x00000020U
#define SRT_EPLCN_INTERRUPTS_ENABLE_COL_VAL  5
#define MSK_EPLCN_INTERRUPTS_ENABLE_COL_RES2 0xffffffc0U
#define SRT_EPLCN_INTERRUPTS_ENABLE_COL_RES2 6

enum {
	BFW_EPLCN_INTERRUPTS_ENABLE_COL_RES1 = 5,  /* [4:0] */
	BFW_EPLCN_INTERRUPTS_ENABLE_COL_VAL  = 1,  /* [5] */
	BFW_EPLCN_INTERRUPTS_ENABLE_COL_RES2 = 26  /* [31:6] */
};

typedef struct EPLCN_INTERRUPTS_ENABLE_COL_BIT_Ttag {
	unsigned int RES1 : BFW_EPLCN_INTERRUPTS_ENABLE_COL_RES1; /* reserved, shall be set to zero */
	unsigned int VAL  : BFW_EPLCN_INTERRUPTS_ENABLE_COL_VAL;  /* enabled collision event        */
	unsigned int RES2 : BFW_EPLCN_INTERRUPTS_ENABLE_COL_RES2; /* reserved, shall be set to zero */
} EPLCN_INTERRUPTS_ENABLE_COL_BIT_T;

typedef union {
	unsigned int                      val;
	EPLCN_INTERRUPTS_ENABLE_COL_BIT_T bf;
} EPLCN_INTERRUPTS_ENABLE_COL_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_INTERRUPTS_ENABLE_EPL_FRAME_DROPPED */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_INTERRUPTS_ENABLE_EPL_FRAME_DROPPED       0x00000088U

#define MSK_EPLCN_INTERRUPTS_ENABLE_EPL_FRAME_DROPPED_RES1 0x0000003fU
#define SRT_EPLCN_INTERRUPTS_ENABLE_EPL_FRAME_DROPPED_RES1 0
#define MSK_EPLCN_INTERRUPTS_ENABLE_EPL_FRAME_DROPPED_VAL  0x00000040U
#define SRT_EPLCN_INTERRUPTS_ENABLE_EPL_FRAME_DROPPED_VAL  6
#define MSK_EPLCN_INTERRUPTS_ENABLE_EPL_FRAME_DROPPED_RES2 0xffffff80U
#define SRT_EPLCN_INTERRUPTS_ENABLE_EPL_FRAME_DROPPED_RES2 7

enum {
	BFW_EPLCN_INTERRUPTS_ENABLE_EPL_FRAME_DROPPED_RES1 = 6,  /* [5:0] */
	BFW_EPLCN_INTERRUPTS_ENABLE_EPL_FRAME_DROPPED_VAL  = 1,  /* [6] */
	BFW_EPLCN_INTERRUPTS_ENABLE_EPL_FRAME_DROPPED_RES2 = 25  /* [31:7] */
};

typedef struct EPLCN_INTERRUPTS_ENABLE_EPL_FRAME_DROPPED_BIT_Ttag {
	unsigned int RES1 : BFW_EPLCN_INTERRUPTS_ENABLE_EPL_FRAME_DROPPED_RES1; /* reserved, shall be set to zero                        */
	unsigned int VAL  : BFW_EPLCN_INTERRUPTS_ENABLE_EPL_FRAME_DROPPED_VAL;  /* enable EPL frame (SoC, PReq, PRsp, SoA) dropped event */
	unsigned int RES2 : BFW_EPLCN_INTERRUPTS_ENABLE_EPL_FRAME_DROPPED_RES2; /* reserved, shall be set to zero                        */
} EPLCN_INTERRUPTS_ENABLE_EPL_FRAME_DROPPED_BIT_T;

typedef union {
	unsigned int                                    val;
	EPLCN_INTERRUPTS_ENABLE_EPL_FRAME_DROPPED_BIT_T bf;
} EPLCN_INTERRUPTS_ENABLE_EPL_FRAME_DROPPED_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_INTERRUPTS_ENABLE_INTERNAL_ERROR */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_INTERRUPTS_ENABLE_INTERNAL_ERROR       0x0000008CU

#define MSK_EPLCN_INTERRUPTS_ENABLE_INTERNAL_ERROR_RES1 0x0000007fU
#define SRT_EPLCN_INTERRUPTS_ENABLE_INTERNAL_ERROR_RES1 0
#define MSK_EPLCN_INTERRUPTS_ENABLE_INTERNAL_ERROR_VAL  0x00000080U
#define SRT_EPLCN_INTERRUPTS_ENABLE_INTERNAL_ERROR_VAL  7
#define MSK_EPLCN_INTERRUPTS_ENABLE_INTERNAL_ERROR_RES2 0xffffff00U
#define SRT_EPLCN_INTERRUPTS_ENABLE_INTERNAL_ERROR_RES2 8

enum {
	BFW_EPLCN_INTERRUPTS_ENABLE_INTERNAL_ERROR_RES1 = 7,  /* [6:0] */
	BFW_EPLCN_INTERRUPTS_ENABLE_INTERNAL_ERROR_VAL  = 1,  /* [7] */
	BFW_EPLCN_INTERRUPTS_ENABLE_INTERNAL_ERROR_RES2 = 24  /* [31:8] */
};

typedef struct EPLCN_INTERRUPTS_ENABLE_INTERNAL_ERROR_BIT_Ttag {
	unsigned int RES1 : BFW_EPLCN_INTERRUPTS_ENABLE_INTERNAL_ERROR_RES1; /* reserved, shall be set to zero                    */
	unsigned int VAL  : BFW_EPLCN_INTERRUPTS_ENABLE_INTERNAL_ERROR_VAL;  /* enable internal error detected, MAC needs restart */
	unsigned int RES2 : BFW_EPLCN_INTERRUPTS_ENABLE_INTERNAL_ERROR_RES2; /* reserved, shall be set to zero                    */
} EPLCN_INTERRUPTS_ENABLE_INTERNAL_ERROR_BIT_T;

typedef union {
	unsigned int                                 val;
	EPLCN_INTERRUPTS_ENABLE_INTERNAL_ERROR_BIT_T bf;
} EPLCN_INTERRUPTS_ENABLE_INTERNAL_ERROR_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_INTERRUPTS_ENABLE_SOC_RCVD */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_INTERRUPTS_ENABLE_SOC_RCVD       0x00000090U

#define MSK_EPLCN_INTERRUPTS_ENABLE_SOC_RCVD_RES1 0x00000fffU
#define SRT_EPLCN_INTERRUPTS_ENABLE_SOC_RCVD_RES1 0
#define MSK_EPLCN_INTERRUPTS_ENABLE_SOC_RCVD_VAL  0x00001000U
#define SRT_EPLCN_INTERRUPTS_ENABLE_SOC_RCVD_VAL  12
#define MSK_EPLCN_INTERRUPTS_ENABLE_SOC_RCVD_RES2 0xffffe000U
#define SRT_EPLCN_INTERRUPTS_ENABLE_SOC_RCVD_RES2 13

enum {
	BFW_EPLCN_INTERRUPTS_ENABLE_SOC_RCVD_RES1 = 12, /* [11:0] */
	BFW_EPLCN_INTERRUPTS_ENABLE_SOC_RCVD_VAL  = 1,  /* [12] */
	BFW_EPLCN_INTERRUPTS_ENABLE_SOC_RCVD_RES2 = 19  /* [31:13] */
};

typedef struct EPLCN_INTERRUPTS_ENABLE_SOC_RCVD_BIT_Ttag {
	unsigned int RES1 : BFW_EPLCN_INTERRUPTS_ENABLE_SOC_RCVD_RES1; /* reserved, shall be set to zero */
	unsigned int VAL  : BFW_EPLCN_INTERRUPTS_ENABLE_SOC_RCVD_VAL;  /* enable SoC received event      */
	unsigned int RES2 : BFW_EPLCN_INTERRUPTS_ENABLE_SOC_RCVD_RES2; /* reserved, shall be set to zero */
} EPLCN_INTERRUPTS_ENABLE_SOC_RCVD_BIT_T;

typedef union {
	unsigned int                           val;
	EPLCN_INTERRUPTS_ENABLE_SOC_RCVD_BIT_T bf;
} EPLCN_INTERRUPTS_ENABLE_SOC_RCVD_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_INTERRUPTS_ENABLE_PREQ_RCVD */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_INTERRUPTS_ENABLE_PREQ_RCVD       0x00000094U

#define MSK_EPLCN_INTERRUPTS_ENABLE_PREQ_RCVD_RES1 0x00001fffU
#define SRT_EPLCN_INTERRUPTS_ENABLE_PREQ_RCVD_RES1 0
#define MSK_EPLCN_INTERRUPTS_ENABLE_PREQ_RCVD_VAL  0x00002000U
#define SRT_EPLCN_INTERRUPTS_ENABLE_PREQ_RCVD_VAL  13
#define MSK_EPLCN_INTERRUPTS_ENABLE_PREQ_RCVD_RES2 0xffffc000U
#define SRT_EPLCN_INTERRUPTS_ENABLE_PREQ_RCVD_RES2 14

enum {
	BFW_EPLCN_INTERRUPTS_ENABLE_PREQ_RCVD_RES1 = 13, /* [12:0] */
	BFW_EPLCN_INTERRUPTS_ENABLE_PREQ_RCVD_VAL  = 1,  /* [13] */
	BFW_EPLCN_INTERRUPTS_ENABLE_PREQ_RCVD_RES2 = 18  /* [31:14] */
};

typedef struct EPLCN_INTERRUPTS_ENABLE_PREQ_RCVD_BIT_Ttag {
	unsigned int RES1 : BFW_EPLCN_INTERRUPTS_ENABLE_PREQ_RCVD_RES1; /* reserved, shall be set to zero                           */
	unsigned int VAL  : BFW_EPLCN_INTERRUPTS_ENABLE_PREQ_RCVD_VAL;  /* enable Poll request to local node address received event */
	unsigned int RES2 : BFW_EPLCN_INTERRUPTS_ENABLE_PREQ_RCVD_RES2; /* reserved, shall be set to zero                           */
} EPLCN_INTERRUPTS_ENABLE_PREQ_RCVD_BIT_T;

typedef union {
	unsigned int                            val;
	EPLCN_INTERRUPTS_ENABLE_PREQ_RCVD_BIT_T bf;
} EPLCN_INTERRUPTS_ENABLE_PREQ_RCVD_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_INTERRUPTS_ENABLE_PRSP_SENT */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_INTERRUPTS_ENABLE_PRSP_SENT       0x00000098U

#define MSK_EPLCN_INTERRUPTS_ENABLE_PRSP_SENT_RES1 0x00003fffU
#define SRT_EPLCN_INTERRUPTS_ENABLE_PRSP_SENT_RES1 0
#define MSK_EPLCN_INTERRUPTS_ENABLE_PRSP_SENT_VAL  0x00004000U
#define SRT_EPLCN_INTERRUPTS_ENABLE_PRSP_SENT_VAL  14
#define MSK_EPLCN_INTERRUPTS_ENABLE_PRSP_SENT_RES2 0xffff8000U
#define SRT_EPLCN_INTERRUPTS_ENABLE_PRSP_SENT_RES2 15

enum {
	BFW_EPLCN_INTERRUPTS_ENABLE_PRSP_SENT_RES1 = 14, /* [13:0] */
	BFW_EPLCN_INTERRUPTS_ENABLE_PRSP_SENT_VAL  = 1,  /* [14] */
	BFW_EPLCN_INTERRUPTS_ENABLE_PRSP_SENT_RES2 = 17  /* [31:15] */
};

typedef struct EPLCN_INTERRUPTS_ENABLE_PRSP_SENT_BIT_Ttag {
	unsigned int RES1 : BFW_EPLCN_INTERRUPTS_ENABLE_PRSP_SENT_RES1; /* reserved, shall be set to zero  */
	unsigned int VAL  : BFW_EPLCN_INTERRUPTS_ENABLE_PRSP_SENT_VAL;  /* enable Poll response sent event */
	unsigned int RES2 : BFW_EPLCN_INTERRUPTS_ENABLE_PRSP_SENT_RES2; /* reserved, shall be set to zero  */
} EPLCN_INTERRUPTS_ENABLE_PRSP_SENT_BIT_T;

typedef union {
	unsigned int                            val;
	EPLCN_INTERRUPTS_ENABLE_PRSP_SENT_BIT_T bf;
} EPLCN_INTERRUPTS_ENABLE_PRSP_SENT_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_INTERRUPTS_ENABLE_SOA_RCVD */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_INTERRUPTS_ENABLE_SOA_RCVD       0x0000009CU

#define MSK_EPLCN_INTERRUPTS_ENABLE_SOA_RCVD_RES1 0x00007fffU
#define SRT_EPLCN_INTERRUPTS_ENABLE_SOA_RCVD_RES1 0
#define MSK_EPLCN_INTERRUPTS_ENABLE_SOA_RCVD_VAL  0x00008000U
#define SRT_EPLCN_INTERRUPTS_ENABLE_SOA_RCVD_VAL  15
#define MSK_EPLCN_INTERRUPTS_ENABLE_SOA_RCVD_RES2 0xffff0000U
#define SRT_EPLCN_INTERRUPTS_ENABLE_SOA_RCVD_RES2 16

enum {
	BFW_EPLCN_INTERRUPTS_ENABLE_SOA_RCVD_RES1 = 15, /* [14:0] */
	BFW_EPLCN_INTERRUPTS_ENABLE_SOA_RCVD_VAL  = 1,  /* [15] */
	BFW_EPLCN_INTERRUPTS_ENABLE_SOA_RCVD_RES2 = 16  /* [31:16] */
};

typedef struct EPLCN_INTERRUPTS_ENABLE_SOA_RCVD_BIT_Ttag {
	unsigned int RES1 : BFW_EPLCN_INTERRUPTS_ENABLE_SOA_RCVD_RES1; /* reserved, shall be set to zero */
	unsigned int VAL  : BFW_EPLCN_INTERRUPTS_ENABLE_SOA_RCVD_VAL;  /* enable SoA received event      */
	unsigned int RES2 : BFW_EPLCN_INTERRUPTS_ENABLE_SOA_RCVD_RES2; /* reserved, shall be set to zero */
} EPLCN_INTERRUPTS_ENABLE_SOA_RCVD_BIT_T;

typedef union {
	unsigned int                           val;
	EPLCN_INTERRUPTS_ENABLE_SOA_RCVD_BIT_T bf;
} EPLCN_INTERRUPTS_ENABLE_SOA_RCVD_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_LOCAL_MAC_ADDRESS_LO */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_LOCAL_MAC_ADDRESS_LO       0x000000A0U

#define MSK_EPLCN_LOCAL_MAC_ADDRESS_LO_BYTES_4321 0xffffffffU
#define SRT_EPLCN_LOCAL_MAC_ADDRESS_LO_BYTES_4321 0

enum {
	BFW_EPLCN_LOCAL_MAC_ADDRESS_LO_BYTES_4321 = 32  /* [31:0] */
};

typedef struct EPLCN_LOCAL_MAC_ADDRESS_LO_BIT_Ttag {
	unsigned int BYTES_4321 : BFW_EPLCN_LOCAL_MAC_ADDRESS_LO_BYTES_4321; /* MAC address bytes 4,3,2 and 1 */
} EPLCN_LOCAL_MAC_ADDRESS_LO_BIT_T;

typedef union {
	unsigned int                     val;
	EPLCN_LOCAL_MAC_ADDRESS_LO_BIT_T bf;
} EPLCN_LOCAL_MAC_ADDRESS_LO_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_LOCAL_MAC_ADDRESS_HI */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_LOCAL_MAC_ADDRESS_HI       0x000000A4U

#define MSK_EPLCN_LOCAL_MAC_ADDRESS_HI_BYTES_65 0x0000ffffU
#define SRT_EPLCN_LOCAL_MAC_ADDRESS_HI_BYTES_65 0
#define MSK_EPLCN_LOCAL_MAC_ADDRESS_HI_RES1     0xffff0000U
#define SRT_EPLCN_LOCAL_MAC_ADDRESS_HI_RES1     16

enum {
	BFW_EPLCN_LOCAL_MAC_ADDRESS_HI_BYTES_65 = 16, /* [15:0] */
	BFW_EPLCN_LOCAL_MAC_ADDRESS_HI_RES1     = 16  /* [31:16] */
};

typedef struct EPLCN_LOCAL_MAC_ADDRESS_HI_BIT_Ttag {
	unsigned int BYTES_65 : BFW_EPLCN_LOCAL_MAC_ADDRESS_HI_BYTES_65; /* MAC address bytes 6 and 5                                 */
	unsigned int RES1     : BFW_EPLCN_LOCAL_MAC_ADDRESS_HI_RES1;     /* 0x0000: MAC address is valid else: MAC address is invalid */
} EPLCN_LOCAL_MAC_ADDRESS_HI_BIT_T;

typedef union {
	unsigned int                     val;
	EPLCN_LOCAL_MAC_ADDRESS_HI_BIT_T bf;
} EPLCN_LOCAL_MAC_ADDRESS_HI_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_EPL_NODE_ID */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_EPL_NODE_ID       0x000000A8U

#define MSK_EPLCN_EPL_NODE_ID_VAL 0x000000ffU
#define SRT_EPLCN_EPL_NODE_ID_VAL 0
#define MSK_EPLCN_EPL_NODE_ID_RES 0xffffff00U
#define SRT_EPLCN_EPL_NODE_ID_RES 8

enum {
	BFW_EPLCN_EPL_NODE_ID_VAL = 8,  /* [7:0] */
	BFW_EPLCN_EPL_NODE_ID_RES = 24  /* [31:8] */
};

typedef struct EPLCN_EPL_NODE_ID_BIT_Ttag {
	unsigned int VAL : BFW_EPLCN_EPL_NODE_ID_VAL; /* epl node id */
	unsigned int RES : BFW_EPLCN_EPL_NODE_ID_RES; /* res         */
} EPLCN_EPL_NODE_ID_BIT_T;

typedef union {
	unsigned int            val;
	EPLCN_EPL_NODE_ID_BIT_T bf;
} EPLCN_EPL_NODE_ID_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_REQ_FIFOS_LOCKED */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_REQ_FIFOS_LOCKED       0x000000ACU

#define MSK_EPLCN_REQ_FIFOS_LOCKED_VAL 0x00000001U
#define SRT_EPLCN_REQ_FIFOS_LOCKED_VAL 0
#define MSK_EPLCN_REQ_FIFOS_LOCKED_RES 0xfffffffeU
#define SRT_EPLCN_REQ_FIFOS_LOCKED_RES 1

enum {
	BFW_EPLCN_REQ_FIFOS_LOCKED_VAL = 1,  /* [0] */
	BFW_EPLCN_REQ_FIFOS_LOCKED_RES = 31  /* [31:1] */
};

typedef struct EPLCN_REQ_FIFOS_LOCKED_BIT_Ttag {
	unsigned int VAL : BFW_EPLCN_REQ_FIFOS_LOCKED_VAL; /* 1/0: requests fifos are locked (no requests are processed - required for reset of node) */
	unsigned int RES : BFW_EPLCN_REQ_FIFOS_LOCKED_RES; /* res                                                                                     */
} EPLCN_REQ_FIFOS_LOCKED_BIT_T;

typedef union {
	unsigned int                 val;
	EPLCN_REQ_FIFOS_LOCKED_BIT_T bf;
} EPLCN_REQ_FIFOS_LOCKED_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_SYSTIME_BORDER_COPY */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_SYSTIME_BORDER_COPY       0x000000B0U

#define MSK_EPLCN_SYSTIME_BORDER_COPY_VAL 0xffffffffU
#define SRT_EPLCN_SYSTIME_BORDER_COPY_VAL 0

enum {
	BFW_EPLCN_SYSTIME_BORDER_COPY_VAL = 32  /* [31:0] */
};

typedef struct EPLCN_SYSTIME_BORDER_COPY_BIT_Ttag {
	unsigned int VAL : BFW_EPLCN_SYSTIME_BORDER_COPY_VAL; /* wrap-around value of systime_ns, systime_s++ */
} EPLCN_SYSTIME_BORDER_COPY_BIT_T;

typedef union {
	unsigned int                    val;
	EPLCN_SYSTIME_BORDER_COPY_BIT_T bf;
} EPLCN_SYSTIME_BORDER_COPY_T;

/* --------------------------------------------------------------------- */
/* Register AREA_EPLCN_STATUS_AREA_BASE */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_AREA_EPLCN_STATUS_AREA_BASE       0x000000B4U

/* --------------------------------------------------------------------- */
/* Register EPLCN_FRAMES_TRANSMITTED_OK */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_FRAMES_TRANSMITTED_OK       0x000000B4U

#define MSK_EPLCN_FRAMES_TRANSMITTED_OK_CNT 0xffffffffU
#define SRT_EPLCN_FRAMES_TRANSMITTED_OK_CNT 0

enum {
	BFW_EPLCN_FRAMES_TRANSMITTED_OK_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_FRAMES_TRANSMITTED_OK_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_FRAMES_TRANSMITTED_OK_CNT; /* count of frames overall that are successfully transmitted */
} EPLCN_FRAMES_TRANSMITTED_OK_BIT_T;

typedef union {
	unsigned int                      val;
	EPLCN_FRAMES_TRANSMITTED_OK_BIT_T bf;
} EPLCN_FRAMES_TRANSMITTED_OK_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_SINGLE_COLLISION_FRAMES */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_SINGLE_COLLISION_FRAMES       0x000000B8U

#define MSK_EPLCN_SINGLE_COLLISION_FRAMES_CNT 0xffffffffU
#define SRT_EPLCN_SINGLE_COLLISION_FRAMES_CNT 0

enum {
	BFW_EPLCN_SINGLE_COLLISION_FRAMES_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_SINGLE_COLLISION_FRAMES_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_SINGLE_COLLISION_FRAMES_CNT; /* count of frames that are involved into a single collision */
} EPLCN_SINGLE_COLLISION_FRAMES_BIT_T;

typedef union {
	unsigned int                        val;
	EPLCN_SINGLE_COLLISION_FRAMES_BIT_T bf;
} EPLCN_SINGLE_COLLISION_FRAMES_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_MULTIPLE_COLLISION_FRAMES */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_MULTIPLE_COLLISION_FRAMES       0x000000BCU

#define MSK_EPLCN_MULTIPLE_COLLISION_FRAMES_CNT 0xffffffffU
#define SRT_EPLCN_MULTIPLE_COLLISION_FRAMES_CNT 0

enum {
	BFW_EPLCN_MULTIPLE_COLLISION_FRAMES_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_MULTIPLE_COLLISION_FRAMES_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_MULTIPLE_COLLISION_FRAMES_CNT; /* count of frames that are involved into more that one collisions */
} EPLCN_MULTIPLE_COLLISION_FRAMES_BIT_T;

typedef union {
	unsigned int                          val;
	EPLCN_MULTIPLE_COLLISION_FRAMES_BIT_T bf;
} EPLCN_MULTIPLE_COLLISION_FRAMES_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_COLLISIONS_DURING_EPL_MODE */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_COLLISIONS_DURING_EPL_MODE       0x000000C0U

#define MSK_EPLCN_COLLISIONS_DURING_EPL_MODE_CNT 0xffffffffU
#define SRT_EPLCN_COLLISIONS_DURING_EPL_MODE_CNT 0

enum {
	BFW_EPLCN_COLLISIONS_DURING_EPL_MODE_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_COLLISIONS_DURING_EPL_MODE_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_COLLISIONS_DURING_EPL_MODE_CNT; /* count of frames that are involved into a collision during EPL mode */
} EPLCN_COLLISIONS_DURING_EPL_MODE_BIT_T;

typedef union {
	unsigned int                           val;
	EPLCN_COLLISIONS_DURING_EPL_MODE_BIT_T bf;
} EPLCN_COLLISIONS_DURING_EPL_MODE_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_PRES_TRANSMITTED_OK */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_PRES_TRANSMITTED_OK       0x000000C4U

#define MSK_EPLCN_PRES_TRANSMITTED_OK_CNT 0xffffffffU
#define SRT_EPLCN_PRES_TRANSMITTED_OK_CNT 0

enum {
	BFW_EPLCN_PRES_TRANSMITTED_OK_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_PRES_TRANSMITTED_OK_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_PRES_TRANSMITTED_OK_CNT; /* count of EPL Poll Responses that are successfully transmitted */
} EPLCN_PRES_TRANSMITTED_OK_BIT_T;

typedef union {
	unsigned int                    val;
	EPLCN_PRES_TRANSMITTED_OK_BIT_T bf;
} EPLCN_PRES_TRANSMITTED_OK_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_NMT_RSP_TRANSMITTED_OK */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_NMT_RSP_TRANSMITTED_OK       0x000000C8U

#define MSK_EPLCN_NMT_RSP_TRANSMITTED_OK_CNT 0xffffffffU
#define SRT_EPLCN_NMT_RSP_TRANSMITTED_OK_CNT 0

enum {
	BFW_EPLCN_NMT_RSP_TRANSMITTED_OK_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_NMT_RSP_TRANSMITTED_OK_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_NMT_RSP_TRANSMITTED_OK_CNT; /* count of EPL NMT Responses that are successfully transmitted */
} EPLCN_NMT_RSP_TRANSMITTED_OK_BIT_T;

typedef union {
	unsigned int                       val;
	EPLCN_NMT_RSP_TRANSMITTED_OK_BIT_T bf;
} EPLCN_NMT_RSP_TRANSMITTED_OK_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_STATUS_RSP_TRANSMITTED_OK */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_STATUS_RSP_TRANSMITTED_OK       0x000000CCU

#define MSK_EPLCN_STATUS_RSP_TRANSMITTED_OK_CNT 0xffffffffU
#define SRT_EPLCN_STATUS_RSP_TRANSMITTED_OK_CNT 0

enum {
	BFW_EPLCN_STATUS_RSP_TRANSMITTED_OK_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_STATUS_RSP_TRANSMITTED_OK_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_STATUS_RSP_TRANSMITTED_OK_CNT; /* count of EPL Status Responses that are successfully transmitted */
} EPLCN_STATUS_RSP_TRANSMITTED_OK_BIT_T;

typedef union {
	unsigned int                          val;
	EPLCN_STATUS_RSP_TRANSMITTED_OK_BIT_T bf;
} EPLCN_STATUS_RSP_TRANSMITTED_OK_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_IDENT_RSP_TRANSMITTED_OK */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_IDENT_RSP_TRANSMITTED_OK       0x000000D0U

#define MSK_EPLCN_IDENT_RSP_TRANSMITTED_OK_CNT 0xffffffffU
#define SRT_EPLCN_IDENT_RSP_TRANSMITTED_OK_CNT 0

enum {
	BFW_EPLCN_IDENT_RSP_TRANSMITTED_OK_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_IDENT_RSP_TRANSMITTED_OK_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_IDENT_RSP_TRANSMITTED_OK_CNT; /* count of EPL Ident Responses that are successfully transmitted */
} EPLCN_IDENT_RSP_TRANSMITTED_OK_BIT_T;

typedef union {
	unsigned int                         val;
	EPLCN_IDENT_RSP_TRANSMITTED_OK_BIT_T bf;
} EPLCN_IDENT_RSP_TRANSMITTED_OK_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_ASND_TRANSMITTED_OK */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_ASND_TRANSMITTED_OK       0x000000D4U

#define MSK_EPLCN_ASND_TRANSMITTED_OK_CNT 0xffffffffU
#define SRT_EPLCN_ASND_TRANSMITTED_OK_CNT 0

enum {
	BFW_EPLCN_ASND_TRANSMITTED_OK_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_ASND_TRANSMITTED_OK_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_ASND_TRANSMITTED_OK_CNT; /* count of EPL ASnd frames that are successfully transmitted */
} EPLCN_ASND_TRANSMITTED_OK_BIT_T;

typedef union {
	unsigned int                    val;
	EPLCN_ASND_TRANSMITTED_OK_BIT_T bf;
} EPLCN_ASND_TRANSMITTED_OK_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_UNKNOWN_EPL_FRAME_TRANSMITTED_OK */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_UNKNOWN_EPL_FRAME_TRANSMITTED_OK       0x000000D8U

#define MSK_EPLCN_UNKNOWN_EPL_FRAME_TRANSMITTED_OK_CNT 0xffffffffU
#define SRT_EPLCN_UNKNOWN_EPL_FRAME_TRANSMITTED_OK_CNT 0

enum {
	BFW_EPLCN_UNKNOWN_EPL_FRAME_TRANSMITTED_OK_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_UNKNOWN_EPL_FRAME_TRANSMITTED_OK_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_UNKNOWN_EPL_FRAME_TRANSMITTED_OK_CNT; /* count of unknown EPL frames that are successfully transmitted */
} EPLCN_UNKNOWN_EPL_FRAME_TRANSMITTED_OK_BIT_T;

typedef union {
	unsigned int                                 val;
	EPLCN_UNKNOWN_EPL_FRAME_TRANSMITTED_OK_BIT_T bf;
} EPLCN_UNKNOWN_EPL_FRAME_TRANSMITTED_OK_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_UTX0_2FREE_UTX1_FULL */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_UTX0_2FREE_UTX1_FULL       0x000000DCU

#define MSK_EPLCN_UTX0_2FREE_UTX1_FULL_CNT 0xffffffffU
#define SRT_EPLCN_UTX0_2FREE_UTX1_FULL_CNT 0

enum {
	BFW_EPLCN_UTX0_2FREE_UTX1_FULL_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_UTX0_2FREE_UTX1_FULL_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_UTX0_2FREE_UTX1_FULL_CNT; /* count of occurences where 2 bytes free in utx0 fifo but utx1 fifo is full */
} EPLCN_UTX0_2FREE_UTX1_FULL_BIT_T;

typedef union {
	unsigned int                     val;
	EPLCN_UTX0_2FREE_UTX1_FULL_BIT_T bf;
} EPLCN_UTX0_2FREE_UTX1_FULL_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_COLLISIONS_PRES */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_COLLISIONS_PRES       0x000000E0U

#define MSK_EPLCN_COLLISIONS_PRES_CNT 0xffffffffU
#define SRT_EPLCN_COLLISIONS_PRES_CNT 0

enum {
	BFW_EPLCN_COLLISIONS_PRES_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_COLLISIONS_PRES_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_COLLISIONS_PRES_CNT; /* count of frames that are involved into a collision during transmit of EPL Poll Response */
} EPLCN_COLLISIONS_PRES_BIT_T;

typedef union {
	unsigned int                val;
	EPLCN_COLLISIONS_PRES_BIT_T bf;
} EPLCN_COLLISIONS_PRES_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_COLLISIONS_NMT_RSP */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_COLLISIONS_NMT_RSP       0x000000E4U

#define MSK_EPLCN_COLLISIONS_NMT_RSP_CNT 0xffffffffU
#define SRT_EPLCN_COLLISIONS_NMT_RSP_CNT 0

enum {
	BFW_EPLCN_COLLISIONS_NMT_RSP_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_COLLISIONS_NMT_RSP_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_COLLISIONS_NMT_RSP_CNT; /* count of frames that are involved into a collision during transmit of EPL NMT Response */
} EPLCN_COLLISIONS_NMT_RSP_BIT_T;

typedef union {
	unsigned int                   val;
	EPLCN_COLLISIONS_NMT_RSP_BIT_T bf;
} EPLCN_COLLISIONS_NMT_RSP_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_COLLISIONS_STATUS_RSP */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_COLLISIONS_STATUS_RSP       0x000000E8U

#define MSK_EPLCN_COLLISIONS_STATUS_RSP_CNT 0xffffffffU
#define SRT_EPLCN_COLLISIONS_STATUS_RSP_CNT 0

enum {
	BFW_EPLCN_COLLISIONS_STATUS_RSP_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_COLLISIONS_STATUS_RSP_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_COLLISIONS_STATUS_RSP_CNT; /* count of frames that are involved into a collision during transmit of EPL Status Response */
} EPLCN_COLLISIONS_STATUS_RSP_BIT_T;

typedef union {
	unsigned int                      val;
	EPLCN_COLLISIONS_STATUS_RSP_BIT_T bf;
} EPLCN_COLLISIONS_STATUS_RSP_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_COLLISIONS_IDENT_RSP */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_COLLISIONS_IDENT_RSP       0x000000ECU

#define MSK_EPLCN_COLLISIONS_IDENT_RSP_CNT 0xffffffffU
#define SRT_EPLCN_COLLISIONS_IDENT_RSP_CNT 0

enum {
	BFW_EPLCN_COLLISIONS_IDENT_RSP_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_COLLISIONS_IDENT_RSP_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_COLLISIONS_IDENT_RSP_CNT; /* count of frames that are involved into a collision during transmit of EPL Ident Response */
} EPLCN_COLLISIONS_IDENT_RSP_BIT_T;

typedef union {
	unsigned int                     val;
	EPLCN_COLLISIONS_IDENT_RSP_BIT_T bf;
} EPLCN_COLLISIONS_IDENT_RSP_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_COLLISIONS_ASND */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_COLLISIONS_ASND       0x000000F0U

#define MSK_EPLCN_COLLISIONS_ASND_CNT 0xffffffffU
#define SRT_EPLCN_COLLISIONS_ASND_CNT 0

enum {
	BFW_EPLCN_COLLISIONS_ASND_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_COLLISIONS_ASND_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_COLLISIONS_ASND_CNT; /* count of frames that are involved into a collision during transmit of EPL ASnd */
} EPLCN_COLLISIONS_ASND_BIT_T;

typedef union {
	unsigned int                val;
	EPLCN_COLLISIONS_ASND_BIT_T bf;
} EPLCN_COLLISIONS_ASND_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_COLLISIONS_UNKNOWN_EPL_FRAME */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_COLLISIONS_UNKNOWN_EPL_FRAME       0x000000F4U

#define MSK_EPLCN_COLLISIONS_UNKNOWN_EPL_FRAME_CNT 0xffffffffU
#define SRT_EPLCN_COLLISIONS_UNKNOWN_EPL_FRAME_CNT 0

enum {
	BFW_EPLCN_COLLISIONS_UNKNOWN_EPL_FRAME_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_COLLISIONS_UNKNOWN_EPL_FRAME_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_COLLISIONS_UNKNOWN_EPL_FRAME_CNT; /* count of frames that are involved into a collision during transmit of unknown EPL frame */
} EPLCN_COLLISIONS_UNKNOWN_EPL_FRAME_BIT_T;

typedef union {
	unsigned int                             val;
	EPLCN_COLLISIONS_UNKNOWN_EPL_FRAME_BIT_T bf;
} EPLCN_COLLISIONS_UNKNOWN_EPL_FRAME_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_FRAMES_RECEIVED_OK */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_FRAMES_RECEIVED_OK       0x000000F8U

#define MSK_EPLCN_FRAMES_RECEIVED_OK_CNT 0xffffffffU
#define SRT_EPLCN_FRAMES_RECEIVED_OK_CNT 0

enum {
	BFW_EPLCN_FRAMES_RECEIVED_OK_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_FRAMES_RECEIVED_OK_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_FRAMES_RECEIVED_OK_CNT; /* count of frames that are successfully received */
} EPLCN_FRAMES_RECEIVED_OK_BIT_T;

typedef union {
	unsigned int                   val;
	EPLCN_FRAMES_RECEIVED_OK_BIT_T bf;
} EPLCN_FRAMES_RECEIVED_OK_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_FRAME_CHECK_SEQUENCE_ERRORS */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_FRAME_CHECK_SEQUENCE_ERRORS       0x000000FCU

#define MSK_EPLCN_FRAME_CHECK_SEQUENCE_ERRORS_CNT 0xffffffffU
#define SRT_EPLCN_FRAME_CHECK_SEQUENCE_ERRORS_CNT 0

enum {
	BFW_EPLCN_FRAME_CHECK_SEQUENCE_ERRORS_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_FRAME_CHECK_SEQUENCE_ERRORS_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_FRAME_CHECK_SEQUENCE_ERRORS_CNT; /* count of frames that are an integral number of octets in length and do not pass the FCS check */
} EPLCN_FRAME_CHECK_SEQUENCE_ERRORS_BIT_T;

typedef union {
	unsigned int                            val;
	EPLCN_FRAME_CHECK_SEQUENCE_ERRORS_BIT_T bf;
} EPLCN_FRAME_CHECK_SEQUENCE_ERRORS_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_ALIGNMENT_ERRORS */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_ALIGNMENT_ERRORS       0x00000100U

#define MSK_EPLCN_ALIGNMENT_ERRORS_CNT 0xffffffffU
#define SRT_EPLCN_ALIGNMENT_ERRORS_CNT 0

enum {
	BFW_EPLCN_ALIGNMENT_ERRORS_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_ALIGNMENT_ERRORS_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_ALIGNMENT_ERRORS_CNT; /* count of frames that are not an integral number of octets in length and do not pass the FCS check */
} EPLCN_ALIGNMENT_ERRORS_BIT_T;

typedef union {
	unsigned int                 val;
	EPLCN_ALIGNMENT_ERRORS_BIT_T bf;
} EPLCN_ALIGNMENT_ERRORS_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_FRAME_TOO_LONG_ERRORS */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_FRAME_TOO_LONG_ERRORS       0x00000104U

#define MSK_EPLCN_FRAME_TOO_LONG_ERRORS_CNT 0xffffffffU
#define SRT_EPLCN_FRAME_TOO_LONG_ERRORS_CNT 0

enum {
	BFW_EPLCN_FRAME_TOO_LONG_ERRORS_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_FRAME_TOO_LONG_ERRORS_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_FRAME_TOO_LONG_ERRORS_CNT; /* count of frames that are received and exceed the maximum permitted frame size */
} EPLCN_FRAME_TOO_LONG_ERRORS_BIT_T;

typedef union {
	unsigned int                      val;
	EPLCN_FRAME_TOO_LONG_ERRORS_BIT_T bf;
} EPLCN_FRAME_TOO_LONG_ERRORS_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_COLLISION_FRAGMENTS_RECEIVED */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_COLLISION_FRAGMENTS_RECEIVED       0x00000108U

#define MSK_EPLCN_COLLISION_FRAGMENTS_RECEIVED_CNT 0xffffffffU
#define SRT_EPLCN_COLLISION_FRAGMENTS_RECEIVED_CNT 0

enum {
	BFW_EPLCN_COLLISION_FRAGMENTS_RECEIVED_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_COLLISION_FRAGMENTS_RECEIVED_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_COLLISION_FRAGMENTS_RECEIVED_CNT; /* count of frames that are smaller that 64 bytes and have a invalid CRC */
} EPLCN_COLLISION_FRAGMENTS_RECEIVED_BIT_T;

typedef union {
	unsigned int                             val;
	EPLCN_COLLISION_FRAGMENTS_RECEIVED_BIT_T bf;
} EPLCN_COLLISION_FRAGMENTS_RECEIVED_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_FRAMES_DROPPED_DUE_LOW_RESOURCE_EPL */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_FRAMES_DROPPED_DUE_LOW_RESOURCE_EPL       0x0000010CU

#define MSK_EPLCN_FRAMES_DROPPED_DUE_LOW_RESOURCE_EPL_CNT 0xffffffffU
#define SRT_EPLCN_FRAMES_DROPPED_DUE_LOW_RESOURCE_EPL_CNT 0

enum {
	BFW_EPLCN_FRAMES_DROPPED_DUE_LOW_RESOURCE_EPL_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_FRAMES_DROPPED_DUE_LOW_RESOURCE_EPL_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_FRAMES_DROPPED_DUE_LOW_RESOURCE_EPL_CNT; /* no empty pointer available at indication time */
} EPLCN_FRAMES_DROPPED_DUE_LOW_RESOURCE_EPL_BIT_T;

typedef union {
	unsigned int                                    val;
	EPLCN_FRAMES_DROPPED_DUE_LOW_RESOURCE_EPL_BIT_T bf;
} EPLCN_FRAMES_DROPPED_DUE_LOW_RESOURCE_EPL_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_FRAMES_DROPPED_DUE_LOW_RESOURCE_NON_EPL */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_FRAMES_DROPPED_DUE_LOW_RESOURCE_NON_EPL       0x00000110U

#define MSK_EPLCN_FRAMES_DROPPED_DUE_LOW_RESOURCE_NON_EPL_CNT 0xffffffffU
#define SRT_EPLCN_FRAMES_DROPPED_DUE_LOW_RESOURCE_NON_EPL_CNT 0

enum {
	BFW_EPLCN_FRAMES_DROPPED_DUE_LOW_RESOURCE_NON_EPL_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_FRAMES_DROPPED_DUE_LOW_RESOURCE_NON_EPL_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_FRAMES_DROPPED_DUE_LOW_RESOURCE_NON_EPL_CNT; /* no empty pointer available at indication time */
} EPLCN_FRAMES_DROPPED_DUE_LOW_RESOURCE_NON_EPL_BIT_T;

typedef union {
	unsigned int                                        val;
	EPLCN_FRAMES_DROPPED_DUE_LOW_RESOURCE_NON_EPL_BIT_T bf;
} EPLCN_FRAMES_DROPPED_DUE_LOW_RESOURCE_NON_EPL_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_FRAME_PREAMBLE_NIB_LEN_NOT_16_P0 */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_FRAME_PREAMBLE_NIB_LEN_NOT_16_P0       0x00000114U

#define MSK_EPLCN_FRAME_PREAMBLE_NIB_LEN_NOT_16_P0_CNT 0xffffffffU
#define SRT_EPLCN_FRAME_PREAMBLE_NIB_LEN_NOT_16_P0_CNT 0

enum {
	BFW_EPLCN_FRAME_PREAMBLE_NIB_LEN_NOT_16_P0_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_FRAME_PREAMBLE_NIB_LEN_NOT_16_P0_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_FRAME_PREAMBLE_NIB_LEN_NOT_16_P0_CNT; /* count of frames that are received at port 0 with a preamble length unequal to 16 */
} EPLCN_FRAME_PREAMBLE_NIB_LEN_NOT_16_P0_BIT_T;

typedef union {
	unsigned int                                 val;
	EPLCN_FRAME_PREAMBLE_NIB_LEN_NOT_16_P0_BIT_T bf;
} EPLCN_FRAME_PREAMBLE_NIB_LEN_NOT_16_P0_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_FRAME_PREAMBLE_NIB_LEN_NOT_16_P1 */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_FRAME_PREAMBLE_NIB_LEN_NOT_16_P1       0x00000118U

#define MSK_EPLCN_FRAME_PREAMBLE_NIB_LEN_NOT_16_P1_CNT 0xffffffffU
#define SRT_EPLCN_FRAME_PREAMBLE_NIB_LEN_NOT_16_P1_CNT 0

enum {
	BFW_EPLCN_FRAME_PREAMBLE_NIB_LEN_NOT_16_P1_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_FRAME_PREAMBLE_NIB_LEN_NOT_16_P1_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_FRAME_PREAMBLE_NIB_LEN_NOT_16_P1_CNT; /* count of frames that are received at port 1 with a preamble length unequal to 16 */
} EPLCN_FRAME_PREAMBLE_NIB_LEN_NOT_16_P1_BIT_T;

typedef union {
	unsigned int                                 val;
	EPLCN_FRAME_PREAMBLE_NIB_LEN_NOT_16_P1_BIT_T bf;
} EPLCN_FRAME_PREAMBLE_NIB_LEN_NOT_16_P1_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_FRAME_RCVD_OK_WITH_DRIBNIB_AND_FCS_OK */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_FRAME_RCVD_OK_WITH_DRIBNIB_AND_FCS_OK       0x0000011CU

#define MSK_EPLCN_FRAME_RCVD_OK_WITH_DRIBNIB_AND_FCS_OK_CNT 0xffffffffU
#define SRT_EPLCN_FRAME_RCVD_OK_WITH_DRIBNIB_AND_FCS_OK_CNT 0

enum {
	BFW_EPLCN_FRAME_RCVD_OK_WITH_DRIBNIB_AND_FCS_OK_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_FRAME_RCVD_OK_WITH_DRIBNIB_AND_FCS_OK_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_FRAME_RCVD_OK_WITH_DRIBNIB_AND_FCS_OK_CNT; /* count of frames that are received ok with dribble nibble */
} EPLCN_FRAME_RCVD_OK_WITH_DRIBNIB_AND_FCS_OK_BIT_T;

typedef union {
	unsigned int                                      val;
	EPLCN_FRAME_RCVD_OK_WITH_DRIBNIB_AND_FCS_OK_BIT_T bf;
} EPLCN_FRAME_RCVD_OK_WITH_DRIBNIB_AND_FCS_OK_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_SOC_DETECTED */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_SOC_DETECTED       0x00000120U

#define MSK_EPLCN_SOC_DETECTED_CNT 0xffffffffU
#define SRT_EPLCN_SOC_DETECTED_CNT 0

enum {
	BFW_EPLCN_SOC_DETECTED_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_SOC_DETECTED_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_SOC_DETECTED_CNT; /* count of frames of type "Start Of Cycle Requests" that are detected */
} EPLCN_SOC_DETECTED_BIT_T;

typedef union {
	unsigned int             val;
	EPLCN_SOC_DETECTED_BIT_T bf;
} EPLCN_SOC_DETECTED_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_POLLREQ_FOR_LOCAL_NODE_DETECTED */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_POLLREQ_FOR_LOCAL_NODE_DETECTED       0x00000124U

#define MSK_EPLCN_POLLREQ_FOR_LOCAL_NODE_DETECTED_CNT 0xffffffffU
#define SRT_EPLCN_POLLREQ_FOR_LOCAL_NODE_DETECTED_CNT 0

enum {
	BFW_EPLCN_POLLREQ_FOR_LOCAL_NODE_DETECTED_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_POLLREQ_FOR_LOCAL_NODE_DETECTED_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_POLLREQ_FOR_LOCAL_NODE_DETECTED_CNT; /* count of frames of type "PollRequests of local node" that are detected */
} EPLCN_POLLREQ_FOR_LOCAL_NODE_DETECTED_BIT_T;

typedef union {
	unsigned int                                val;
	EPLCN_POLLREQ_FOR_LOCAL_NODE_DETECTED_BIT_T bf;
} EPLCN_POLLREQ_FOR_LOCAL_NODE_DETECTED_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_POLLREQ_FOR_REMOTE_NODE_DETECTED */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_POLLREQ_FOR_REMOTE_NODE_DETECTED       0x00000128U

#define MSK_EPLCN_POLLREQ_FOR_REMOTE_NODE_DETECTED_CNT 0xffffffffU
#define SRT_EPLCN_POLLREQ_FOR_REMOTE_NODE_DETECTED_CNT 0

enum {
	BFW_EPLCN_POLLREQ_FOR_REMOTE_NODE_DETECTED_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_POLLREQ_FOR_REMOTE_NODE_DETECTED_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_POLLREQ_FOR_REMOTE_NODE_DETECTED_CNT; /* count of frames of type "PollRequests of remote node" that are detected */
} EPLCN_POLLREQ_FOR_REMOTE_NODE_DETECTED_BIT_T;

typedef union {
	unsigned int                                 val;
	EPLCN_POLLREQ_FOR_REMOTE_NODE_DETECTED_BIT_T bf;
} EPLCN_POLLREQ_FOR_REMOTE_NODE_DETECTED_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_POLLRES_OF_REMOTE_NODE_DETECTED */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_POLLRES_OF_REMOTE_NODE_DETECTED       0x0000012CU

#define MSK_EPLCN_POLLRES_OF_REMOTE_NODE_DETECTED_CNT 0xffffffffU
#define SRT_EPLCN_POLLRES_OF_REMOTE_NODE_DETECTED_CNT 0

enum {
	BFW_EPLCN_POLLRES_OF_REMOTE_NODE_DETECTED_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_POLLRES_OF_REMOTE_NODE_DETECTED_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_POLLRES_OF_REMOTE_NODE_DETECTED_CNT; /* count of frames of type "PollResponse of remote node" that are detected */
} EPLCN_POLLRES_OF_REMOTE_NODE_DETECTED_BIT_T;

typedef union {
	unsigned int                                val;
	EPLCN_POLLRES_OF_REMOTE_NODE_DETECTED_BIT_T bf;
} EPLCN_POLLRES_OF_REMOTE_NODE_DETECTED_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_SOA_TO_REMOTE_NODE_DETECTED */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_SOA_TO_REMOTE_NODE_DETECTED       0x00000130U

#define MSK_EPLCN_SOA_TO_REMOTE_NODE_DETECTED_CNT 0xffffffffU
#define SRT_EPLCN_SOA_TO_REMOTE_NODE_DETECTED_CNT 0

enum {
	BFW_EPLCN_SOA_TO_REMOTE_NODE_DETECTED_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_SOA_TO_REMOTE_NODE_DETECTED_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_SOA_TO_REMOTE_NODE_DETECTED_CNT; /* count of frames of type "SoA to remote node " that are detected */
} EPLCN_SOA_TO_REMOTE_NODE_DETECTED_BIT_T;

typedef union {
	unsigned int                            val;
	EPLCN_SOA_TO_REMOTE_NODE_DETECTED_BIT_T bf;
} EPLCN_SOA_TO_REMOTE_NODE_DETECTED_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_SOA_NO_SERVICE_DETECTED */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_SOA_NO_SERVICE_DETECTED       0x00000134U

#define MSK_EPLCN_SOA_NO_SERVICE_DETECTED_CNT 0xffffffffU
#define SRT_EPLCN_SOA_NO_SERVICE_DETECTED_CNT 0

enum {
	BFW_EPLCN_SOA_NO_SERVICE_DETECTED_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_SOA_NO_SERVICE_DETECTED_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_SOA_NO_SERVICE_DETECTED_CNT; /* count of frames of type "SoA No service" that are detected */
} EPLCN_SOA_NO_SERVICE_DETECTED_BIT_T;

typedef union {
	unsigned int                        val;
	EPLCN_SOA_NO_SERVICE_DETECTED_BIT_T bf;
} EPLCN_SOA_NO_SERVICE_DETECTED_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_SOA_IDENT_REQ_DETECTED */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_SOA_IDENT_REQ_DETECTED       0x00000138U

#define MSK_EPLCN_SOA_IDENT_REQ_DETECTED_CNT 0xffffffffU
#define SRT_EPLCN_SOA_IDENT_REQ_DETECTED_CNT 0

enum {
	BFW_EPLCN_SOA_IDENT_REQ_DETECTED_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_SOA_IDENT_REQ_DETECTED_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_SOA_IDENT_REQ_DETECTED_CNT; /* count of frames of type "SoA Ident Request" that are detected */
} EPLCN_SOA_IDENT_REQ_DETECTED_BIT_T;

typedef union {
	unsigned int                       val;
	EPLCN_SOA_IDENT_REQ_DETECTED_BIT_T bf;
} EPLCN_SOA_IDENT_REQ_DETECTED_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_SOA_STATUS_REQ_DETECTED */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_SOA_STATUS_REQ_DETECTED       0x0000013CU

#define MSK_EPLCN_SOA_STATUS_REQ_DETECTED_CNT 0xffffffffU
#define SRT_EPLCN_SOA_STATUS_REQ_DETECTED_CNT 0

enum {
	BFW_EPLCN_SOA_STATUS_REQ_DETECTED_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_SOA_STATUS_REQ_DETECTED_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_SOA_STATUS_REQ_DETECTED_CNT; /* count of frames of type "SoA Status Request" that are detected */
} EPLCN_SOA_STATUS_REQ_DETECTED_BIT_T;

typedef union {
	unsigned int                        val;
	EPLCN_SOA_STATUS_REQ_DETECTED_BIT_T bf;
} EPLCN_SOA_STATUS_REQ_DETECTED_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_SOA_NMT_REQUEST_INVITE_DETECTED */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_SOA_NMT_REQUEST_INVITE_DETECTED       0x00000140U

#define MSK_EPLCN_SOA_NMT_REQUEST_INVITE_DETECTED_CNT 0xffffffffU
#define SRT_EPLCN_SOA_NMT_REQUEST_INVITE_DETECTED_CNT 0

enum {
	BFW_EPLCN_SOA_NMT_REQUEST_INVITE_DETECTED_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_SOA_NMT_REQUEST_INVITE_DETECTED_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_SOA_NMT_REQUEST_INVITE_DETECTED_CNT; /* count of frames of type "SoA NMT Request Invite" that are detected */
} EPLCN_SOA_NMT_REQUEST_INVITE_DETECTED_BIT_T;

typedef union {
	unsigned int                                val;
	EPLCN_SOA_NMT_REQUEST_INVITE_DETECTED_BIT_T bf;
} EPLCN_SOA_NMT_REQUEST_INVITE_DETECTED_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_SOA_UNSPECIFIED_INVITE_DETECTED */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_SOA_UNSPECIFIED_INVITE_DETECTED       0x00000144U

#define MSK_EPLCN_SOA_UNSPECIFIED_INVITE_DETECTED_CNT 0xffffffffU
#define SRT_EPLCN_SOA_UNSPECIFIED_INVITE_DETECTED_CNT 0

enum {
	BFW_EPLCN_SOA_UNSPECIFIED_INVITE_DETECTED_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_SOA_UNSPECIFIED_INVITE_DETECTED_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_SOA_UNSPECIFIED_INVITE_DETECTED_CNT; /* count of frames of type "SoA Unspecified Invite Request" that are detected */
} EPLCN_SOA_UNSPECIFIED_INVITE_DETECTED_BIT_T;

typedef union {
	unsigned int                                val;
	EPLCN_SOA_UNSPECIFIED_INVITE_DETECTED_BIT_T bf;
} EPLCN_SOA_UNSPECIFIED_INVITE_DETECTED_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_SOA_LOCAL_NODE_UNKNOWN_SERVICE_DETECTED */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_SOA_LOCAL_NODE_UNKNOWN_SERVICE_DETECTED       0x00000148U

#define MSK_EPLCN_SOA_LOCAL_NODE_UNKNOWN_SERVICE_DETECTED_CNT 0xffffffffU
#define SRT_EPLCN_SOA_LOCAL_NODE_UNKNOWN_SERVICE_DETECTED_CNT 0

enum {
	BFW_EPLCN_SOA_LOCAL_NODE_UNKNOWN_SERVICE_DETECTED_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_SOA_LOCAL_NODE_UNKNOWN_SERVICE_DETECTED_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_SOA_LOCAL_NODE_UNKNOWN_SERVICE_DETECTED_CNT; /* count of frames of type "SoA wiht unknown service ID" that are detected */
} EPLCN_SOA_LOCAL_NODE_UNKNOWN_SERVICE_DETECTED_BIT_T;

typedef union {
	unsigned int                                        val;
	EPLCN_SOA_LOCAL_NODE_UNKNOWN_SERVICE_DETECTED_BIT_T bf;
} EPLCN_SOA_LOCAL_NODE_UNKNOWN_SERVICE_DETECTED_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_ASND_DETECTED */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_ASND_DETECTED       0x0000014CU

#define MSK_EPLCN_ASND_DETECTED_CNT 0xffffffffU
#define SRT_EPLCN_ASND_DETECTED_CNT 0

enum {
	BFW_EPLCN_ASND_DETECTED_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_ASND_DETECTED_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_ASND_DETECTED_CNT; /* count of frames of type "ASnd" that are detected */
} EPLCN_ASND_DETECTED_BIT_T;

typedef union {
	unsigned int              val;
	EPLCN_ASND_DETECTED_BIT_T bf;
} EPLCN_ASND_DETECTED_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_UNKNOWN_EPL_MSG_TYPE_DETECTED */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_UNKNOWN_EPL_MSG_TYPE_DETECTED       0x00000150U

#define MSK_EPLCN_UNKNOWN_EPL_MSG_TYPE_DETECTED_CNT 0xffffffffU
#define SRT_EPLCN_UNKNOWN_EPL_MSG_TYPE_DETECTED_CNT 0

enum {
	BFW_EPLCN_UNKNOWN_EPL_MSG_TYPE_DETECTED_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_UNKNOWN_EPL_MSG_TYPE_DETECTED_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_UNKNOWN_EPL_MSG_TYPE_DETECTED_CNT; /* count of unknown EPL frames that are detected */
} EPLCN_UNKNOWN_EPL_MSG_TYPE_DETECTED_BIT_T;

typedef union {
	unsigned int                              val;
	EPLCN_UNKNOWN_EPL_MSG_TYPE_DETECTED_BIT_T bf;
} EPLCN_UNKNOWN_EPL_MSG_TYPE_DETECTED_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_SOC_RECEIVED_OK */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_SOC_RECEIVED_OK       0x00000154U

#define MSK_EPLCN_SOC_RECEIVED_OK_CNT 0xffffffffU
#define SRT_EPLCN_SOC_RECEIVED_OK_CNT 0

enum {
	BFW_EPLCN_SOC_RECEIVED_OK_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_SOC_RECEIVED_OK_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_SOC_RECEIVED_OK_CNT; /* count of frames of type "Start Of Cycle Requests" that are successfully received */
} EPLCN_SOC_RECEIVED_OK_BIT_T;

typedef union {
	unsigned int                val;
	EPLCN_SOC_RECEIVED_OK_BIT_T bf;
} EPLCN_SOC_RECEIVED_OK_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_POLLREQ_FOR_LOCAL_NODE_RECEIVED_OK */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_POLLREQ_FOR_LOCAL_NODE_RECEIVED_OK       0x00000158U

#define MSK_EPLCN_POLLREQ_FOR_LOCAL_NODE_RECEIVED_OK_CNT 0xffffffffU
#define SRT_EPLCN_POLLREQ_FOR_LOCAL_NODE_RECEIVED_OK_CNT 0

enum {
	BFW_EPLCN_POLLREQ_FOR_LOCAL_NODE_RECEIVED_OK_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_POLLREQ_FOR_LOCAL_NODE_RECEIVED_OK_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_POLLREQ_FOR_LOCAL_NODE_RECEIVED_OK_CNT; /* count of frames of type "PollRequests of local node" that are successfully received */
} EPLCN_POLLREQ_FOR_LOCAL_NODE_RECEIVED_OK_BIT_T;

typedef union {
	unsigned int                                   val;
	EPLCN_POLLREQ_FOR_LOCAL_NODE_RECEIVED_OK_BIT_T bf;
} EPLCN_POLLREQ_FOR_LOCAL_NODE_RECEIVED_OK_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_POLLREQ_FOR_REMOTE_NODE_RECEIVED_OK */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_POLLREQ_FOR_REMOTE_NODE_RECEIVED_OK       0x0000015CU

#define MSK_EPLCN_POLLREQ_FOR_REMOTE_NODE_RECEIVED_OK_CNT 0xffffffffU
#define SRT_EPLCN_POLLREQ_FOR_REMOTE_NODE_RECEIVED_OK_CNT 0

enum {
	BFW_EPLCN_POLLREQ_FOR_REMOTE_NODE_RECEIVED_OK_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_POLLREQ_FOR_REMOTE_NODE_RECEIVED_OK_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_POLLREQ_FOR_REMOTE_NODE_RECEIVED_OK_CNT; /* count of frames of type "PollRequests of remote node" that are successfully received */
} EPLCN_POLLREQ_FOR_REMOTE_NODE_RECEIVED_OK_BIT_T;

typedef union {
	unsigned int                                    val;
	EPLCN_POLLREQ_FOR_REMOTE_NODE_RECEIVED_OK_BIT_T bf;
} EPLCN_POLLREQ_FOR_REMOTE_NODE_RECEIVED_OK_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_POLLREQ_FOR_REMOTE_NODE_FILTERED */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_POLLREQ_FOR_REMOTE_NODE_FILTERED       0x00000160U

#define MSK_EPLCN_POLLREQ_FOR_REMOTE_NODE_FILTERED_CNT 0xffffffffU
#define SRT_EPLCN_POLLREQ_FOR_REMOTE_NODE_FILTERED_CNT 0

enum {
	BFW_EPLCN_POLLREQ_FOR_REMOTE_NODE_FILTERED_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_POLLREQ_FOR_REMOTE_NODE_FILTERED_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_POLLREQ_FOR_REMOTE_NODE_FILTERED_CNT; /* count of frames of type "PollRequests of remote node" that are successfully filtered */
} EPLCN_POLLREQ_FOR_REMOTE_NODE_FILTERED_BIT_T;

typedef union {
	unsigned int                                 val;
	EPLCN_POLLREQ_FOR_REMOTE_NODE_FILTERED_BIT_T bf;
} EPLCN_POLLREQ_FOR_REMOTE_NODE_FILTERED_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_POLLRES_OF_REMOTE_NODE_RECEIVED_OK */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_POLLRES_OF_REMOTE_NODE_RECEIVED_OK       0x00000164U

#define MSK_EPLCN_POLLRES_OF_REMOTE_NODE_RECEIVED_OK_CNT 0xffffffffU
#define SRT_EPLCN_POLLRES_OF_REMOTE_NODE_RECEIVED_OK_CNT 0

enum {
	BFW_EPLCN_POLLRES_OF_REMOTE_NODE_RECEIVED_OK_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_POLLRES_OF_REMOTE_NODE_RECEIVED_OK_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_POLLRES_OF_REMOTE_NODE_RECEIVED_OK_CNT; /* count of frames of type "PollResponse of remote node" that are successfully received */
} EPLCN_POLLRES_OF_REMOTE_NODE_RECEIVED_OK_BIT_T;

typedef union {
	unsigned int                                   val;
	EPLCN_POLLRES_OF_REMOTE_NODE_RECEIVED_OK_BIT_T bf;
} EPLCN_POLLRES_OF_REMOTE_NODE_RECEIVED_OK_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_POLLRES_OF_REMOTE_NODE_FILTERED */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_POLLRES_OF_REMOTE_NODE_FILTERED       0x00000168U

#define MSK_EPLCN_POLLRES_OF_REMOTE_NODE_FILTERED_CNT 0xffffffffU
#define SRT_EPLCN_POLLRES_OF_REMOTE_NODE_FILTERED_CNT 0

enum {
	BFW_EPLCN_POLLRES_OF_REMOTE_NODE_FILTERED_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_POLLRES_OF_REMOTE_NODE_FILTERED_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_POLLRES_OF_REMOTE_NODE_FILTERED_CNT; /* count of frames of type "PollResponse of remote node" that are successfully filtered */
} EPLCN_POLLRES_OF_REMOTE_NODE_FILTERED_BIT_T;

typedef union {
	unsigned int                                val;
	EPLCN_POLLRES_OF_REMOTE_NODE_FILTERED_BIT_T bf;
} EPLCN_POLLRES_OF_REMOTE_NODE_FILTERED_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_SOA_NO_SERVICE_RECEIVED_OK */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_SOA_NO_SERVICE_RECEIVED_OK       0x0000016CU

#define MSK_EPLCN_SOA_NO_SERVICE_RECEIVED_OK_CNT 0xffffffffU
#define SRT_EPLCN_SOA_NO_SERVICE_RECEIVED_OK_CNT 0

enum {
	BFW_EPLCN_SOA_NO_SERVICE_RECEIVED_OK_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_SOA_NO_SERVICE_RECEIVED_OK_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_SOA_NO_SERVICE_RECEIVED_OK_CNT; /* count of frames of type "SoA No_Service" that are successfully received */
} EPLCN_SOA_NO_SERVICE_RECEIVED_OK_BIT_T;

typedef union {
	unsigned int                           val;
	EPLCN_SOA_NO_SERVICE_RECEIVED_OK_BIT_T bf;
} EPLCN_SOA_NO_SERVICE_RECEIVED_OK_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_SOA_IDENT_REQ_RECEIVED_OK */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_SOA_IDENT_REQ_RECEIVED_OK       0x00000170U

#define MSK_EPLCN_SOA_IDENT_REQ_RECEIVED_OK_CNT 0xffffffffU
#define SRT_EPLCN_SOA_IDENT_REQ_RECEIVED_OK_CNT 0

enum {
	BFW_EPLCN_SOA_IDENT_REQ_RECEIVED_OK_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_SOA_IDENT_REQ_RECEIVED_OK_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_SOA_IDENT_REQ_RECEIVED_OK_CNT; /* count of frames of type "SoA Ident Request" that are successfully received */
} EPLCN_SOA_IDENT_REQ_RECEIVED_OK_BIT_T;

typedef union {
	unsigned int                          val;
	EPLCN_SOA_IDENT_REQ_RECEIVED_OK_BIT_T bf;
} EPLCN_SOA_IDENT_REQ_RECEIVED_OK_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_SOA_STATUS_REQ_RECEIVED_OK */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_SOA_STATUS_REQ_RECEIVED_OK       0x00000174U

#define MSK_EPLCN_SOA_STATUS_REQ_RECEIVED_OK_CNT 0xffffffffU
#define SRT_EPLCN_SOA_STATUS_REQ_RECEIVED_OK_CNT 0

enum {
	BFW_EPLCN_SOA_STATUS_REQ_RECEIVED_OK_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_SOA_STATUS_REQ_RECEIVED_OK_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_SOA_STATUS_REQ_RECEIVED_OK_CNT; /* count of frames of type "SoA Status Request" that are successfully received */
} EPLCN_SOA_STATUS_REQ_RECEIVED_OK_BIT_T;

typedef union {
	unsigned int                           val;
	EPLCN_SOA_STATUS_REQ_RECEIVED_OK_BIT_T bf;
} EPLCN_SOA_STATUS_REQ_RECEIVED_OK_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_SOA_NMT_REQUEST_INVITE_RECEIVED_OK */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_SOA_NMT_REQUEST_INVITE_RECEIVED_OK       0x00000178U

#define MSK_EPLCN_SOA_NMT_REQUEST_INVITE_RECEIVED_OK_CNT 0xffffffffU
#define SRT_EPLCN_SOA_NMT_REQUEST_INVITE_RECEIVED_OK_CNT 0

enum {
	BFW_EPLCN_SOA_NMT_REQUEST_INVITE_RECEIVED_OK_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_SOA_NMT_REQUEST_INVITE_RECEIVED_OK_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_SOA_NMT_REQUEST_INVITE_RECEIVED_OK_CNT; /* count of frames of type "SoA NMT Request Invite" that are successfully received */
} EPLCN_SOA_NMT_REQUEST_INVITE_RECEIVED_OK_BIT_T;

typedef union {
	unsigned int                                   val;
	EPLCN_SOA_NMT_REQUEST_INVITE_RECEIVED_OK_BIT_T bf;
} EPLCN_SOA_NMT_REQUEST_INVITE_RECEIVED_OK_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_SOA_UNSPECIFIED_INVITE_RECEIVED_OK */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_SOA_UNSPECIFIED_INVITE_RECEIVED_OK       0x0000017CU

#define MSK_EPLCN_SOA_UNSPECIFIED_INVITE_RECEIVED_OK_CNT 0xffffffffU
#define SRT_EPLCN_SOA_UNSPECIFIED_INVITE_RECEIVED_OK_CNT 0

enum {
	BFW_EPLCN_SOA_UNSPECIFIED_INVITE_RECEIVED_OK_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_SOA_UNSPECIFIED_INVITE_RECEIVED_OK_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_SOA_UNSPECIFIED_INVITE_RECEIVED_OK_CNT; /* count of frames of type "SoA Unspecified Invite Request" that are successfully received */
} EPLCN_SOA_UNSPECIFIED_INVITE_RECEIVED_OK_BIT_T;

typedef union {
	unsigned int                                   val;
	EPLCN_SOA_UNSPECIFIED_INVITE_RECEIVED_OK_BIT_T bf;
} EPLCN_SOA_UNSPECIFIED_INVITE_RECEIVED_OK_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_SOA_UNKNOWN_SERVICE_RECEIVED_OK */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_SOA_UNKNOWN_SERVICE_RECEIVED_OK       0x00000180U

#define MSK_EPLCN_SOA_UNKNOWN_SERVICE_RECEIVED_OK_CNT 0xffffffffU
#define SRT_EPLCN_SOA_UNKNOWN_SERVICE_RECEIVED_OK_CNT 0

enum {
	BFW_EPLCN_SOA_UNKNOWN_SERVICE_RECEIVED_OK_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_SOA_UNKNOWN_SERVICE_RECEIVED_OK_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_SOA_UNKNOWN_SERVICE_RECEIVED_OK_CNT; /* count of frames of type "SoA unknown service id" that are successfully received */
} EPLCN_SOA_UNKNOWN_SERVICE_RECEIVED_OK_BIT_T;

typedef union {
	unsigned int                                val;
	EPLCN_SOA_UNKNOWN_SERVICE_RECEIVED_OK_BIT_T bf;
} EPLCN_SOA_UNKNOWN_SERVICE_RECEIVED_OK_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_SOA_REMOTE_NODE_RECEIVED_OK */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_SOA_REMOTE_NODE_RECEIVED_OK       0x00000184U

#define MSK_EPLCN_SOA_REMOTE_NODE_RECEIVED_OK_CNT 0xffffffffU
#define SRT_EPLCN_SOA_REMOTE_NODE_RECEIVED_OK_CNT 0

enum {
	BFW_EPLCN_SOA_REMOTE_NODE_RECEIVED_OK_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_SOA_REMOTE_NODE_RECEIVED_OK_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_SOA_REMOTE_NODE_RECEIVED_OK_CNT; /* count of frames of type "SoA remote node" that are successfully received */
} EPLCN_SOA_REMOTE_NODE_RECEIVED_OK_BIT_T;

typedef union {
	unsigned int                            val;
	EPLCN_SOA_REMOTE_NODE_RECEIVED_OK_BIT_T bf;
} EPLCN_SOA_REMOTE_NODE_RECEIVED_OK_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_ASND_RECEIVED_OK */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_ASND_RECEIVED_OK       0x00000188U

#define MSK_EPLCN_ASND_RECEIVED_OK_CNT 0xffffffffU
#define SRT_EPLCN_ASND_RECEIVED_OK_CNT 0

enum {
	BFW_EPLCN_ASND_RECEIVED_OK_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_ASND_RECEIVED_OK_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_ASND_RECEIVED_OK_CNT; /* count of frames of type "ASnd" that are successfully received */
} EPLCN_ASND_RECEIVED_OK_BIT_T;

typedef union {
	unsigned int                 val;
	EPLCN_ASND_RECEIVED_OK_BIT_T bf;
} EPLCN_ASND_RECEIVED_OK_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_ASND_FILTERED */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_ASND_FILTERED       0x0000018CU

#define MSK_EPLCN_ASND_FILTERED_CNT 0xffffffffU
#define SRT_EPLCN_ASND_FILTERED_CNT 0

enum {
	BFW_EPLCN_ASND_FILTERED_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_ASND_FILTERED_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_ASND_FILTERED_CNT; /* count of frames of type "ASnd" that are successfully filtered */
} EPLCN_ASND_FILTERED_BIT_T;

typedef union {
	unsigned int              val;
	EPLCN_ASND_FILTERED_BIT_T bf;
} EPLCN_ASND_FILTERED_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_UNKNOWN_EPL_MSG_TYPE_RECEIVED_OK */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_UNKNOWN_EPL_MSG_TYPE_RECEIVED_OK       0x00000190U

#define MSK_EPLCN_UNKNOWN_EPL_MSG_TYPE_RECEIVED_OK_CNT 0xffffffffU
#define SRT_EPLCN_UNKNOWN_EPL_MSG_TYPE_RECEIVED_OK_CNT 0

enum {
	BFW_EPLCN_UNKNOWN_EPL_MSG_TYPE_RECEIVED_OK_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_UNKNOWN_EPL_MSG_TYPE_RECEIVED_OK_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_UNKNOWN_EPL_MSG_TYPE_RECEIVED_OK_CNT; /* count of unknown EPL frames that are successfully received */
} EPLCN_UNKNOWN_EPL_MSG_TYPE_RECEIVED_OK_BIT_T;

typedef union {
	unsigned int                                 val;
	EPLCN_UNKNOWN_EPL_MSG_TYPE_RECEIVED_OK_BIT_T bf;
} EPLCN_UNKNOWN_EPL_MSG_TYPE_RECEIVED_OK_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_RX_FRAME_FIN_SET_OUTSIDE_RX_FLOW_P0 */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_RX_FRAME_FIN_SET_OUTSIDE_RX_FLOW_P0       0x00000194U

#define MSK_EPLCN_RX_FRAME_FIN_SET_OUTSIDE_RX_FLOW_P0_CNT 0xffffffffU
#define SRT_EPLCN_RX_FRAME_FIN_SET_OUTSIDE_RX_FLOW_P0_CNT 0

enum {
	BFW_EPLCN_RX_FRAME_FIN_SET_OUTSIDE_RX_FLOW_P0_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_RX_FRAME_FIN_SET_OUTSIDE_RX_FLOW_P0_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_RX_FRAME_FIN_SET_OUTSIDE_RX_FLOW_P0_CNT; /* rx frame finished set outside rx_flow p0 (fatal error) */
} EPLCN_RX_FRAME_FIN_SET_OUTSIDE_RX_FLOW_P0_BIT_T;

typedef union {
	unsigned int                                    val;
	EPLCN_RX_FRAME_FIN_SET_OUTSIDE_RX_FLOW_P0_BIT_T bf;
} EPLCN_RX_FRAME_FIN_SET_OUTSIDE_RX_FLOW_P0_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_RX_FRAME_FIN_SET_OUTSIDE_RX_FLOW_P1 */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_RX_FRAME_FIN_SET_OUTSIDE_RX_FLOW_P1       0x00000198U

#define MSK_EPLCN_RX_FRAME_FIN_SET_OUTSIDE_RX_FLOW_P1_CNT 0xffffffffU
#define SRT_EPLCN_RX_FRAME_FIN_SET_OUTSIDE_RX_FLOW_P1_CNT 0

enum {
	BFW_EPLCN_RX_FRAME_FIN_SET_OUTSIDE_RX_FLOW_P1_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_RX_FRAME_FIN_SET_OUTSIDE_RX_FLOW_P1_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_RX_FRAME_FIN_SET_OUTSIDE_RX_FLOW_P1_CNT; /* rx frame finished set outside rx_flow p1 (fatal error) */
} EPLCN_RX_FRAME_FIN_SET_OUTSIDE_RX_FLOW_P1_BIT_T;

typedef union {
	unsigned int                                    val;
	EPLCN_RX_FRAME_FIN_SET_OUTSIDE_RX_FLOW_P1_BIT_T bf;
} EPLCN_RX_FRAME_FIN_SET_OUTSIDE_RX_FLOW_P1_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_RX_FATAL_ERROR */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_RX_FATAL_ERROR       0x0000019CU

#define MSK_EPLCN_RX_FATAL_ERROR_CNT 0xffffffffU
#define SRT_EPLCN_RX_FATAL_ERROR_CNT 0

enum {
	BFW_EPLCN_RX_FATAL_ERROR_CNT = 32  /* [31:0] */
};

typedef struct EPLCN_RX_FATAL_ERROR_BIT_Ttag {
	unsigned int CNT : BFW_EPLCN_RX_FATAL_ERROR_CNT; /* counts unknown error numbers from RX xMAC, should never occure */
} EPLCN_RX_FATAL_ERROR_BIT_T;

typedef union {
	unsigned int               val;
	EPLCN_RX_FATAL_ERROR_BIT_T bf;
} EPLCN_RX_FATAL_ERROR_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_EPL_NODE_STATUS */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_EPL_NODE_STATUS       0x000001A0U

#define MSK_EPLCN_EPL_NODE_STATUS_EPL_MODE 0x00000001U
#define SRT_EPLCN_EPL_NODE_STATUS_EPL_MODE 0
#define MSK_EPLCN_EPL_NODE_STATUS_RES      0xfffffffeU
#define SRT_EPLCN_EPL_NODE_STATUS_RES      1

enum {
	BFW_EPLCN_EPL_NODE_STATUS_EPL_MODE = 1,  /* [0] */
	BFW_EPLCN_EPL_NODE_STATUS_RES      = 31  /* [31:1] */
};

typedef struct EPLCN_EPL_NODE_STATUS_BIT_Ttag {
	unsigned int EPL_MODE : BFW_EPLCN_EPL_NODE_STATUS_EPL_MODE; /* 1/0: epl mode/basic ethernet mode */
	unsigned int RES      : BFW_EPLCN_EPL_NODE_STATUS_RES;      /* res                               */
} EPLCN_EPL_NODE_STATUS_BIT_T;

typedef union {
	unsigned int                val;
	EPLCN_EPL_NODE_STATUS_BIT_T bf;
} EPLCN_EPL_NODE_STATUS_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_PHY_LEDS */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_PHY_LEDS       0x000001A4U

#define MSK_EPLCN_PHY_LEDS_LINK_UP_P0     0x00000001U
#define SRT_EPLCN_PHY_LEDS_LINK_UP_P0     0
#define MSK_EPLCN_PHY_LEDS_ACTIVITY_P0    0x00000002U
#define SRT_EPLCN_PHY_LEDS_ACTIVITY_P0    1
#define MSK_EPLCN_PHY_LEDS_SPEED_100_P0   0x00000004U
#define SRT_EPLCN_PHY_LEDS_SPEED_100_P0   2
#define MSK_EPLCN_PHY_LEDS_DUPLEX_FULL_P0 0x00000008U
#define SRT_EPLCN_PHY_LEDS_DUPLEX_FULL_P0 3
#define MSK_EPLCN_PHY_LEDS_RES1           0x000000f0U
#define SRT_EPLCN_PHY_LEDS_RES1           4
#define MSK_EPLCN_PHY_LEDS_LINK_UP_P1     0x00000100U
#define SRT_EPLCN_PHY_LEDS_LINK_UP_P1     8
#define MSK_EPLCN_PHY_LEDS_ACTIVITY_P1    0x00000200U
#define SRT_EPLCN_PHY_LEDS_ACTIVITY_P1    9
#define MSK_EPLCN_PHY_LEDS_SPEED_100_P1   0x00000400U
#define SRT_EPLCN_PHY_LEDS_SPEED_100_P1   10
#define MSK_EPLCN_PHY_LEDS_DUPLEX_FULL_P1 0x00000800U
#define SRT_EPLCN_PHY_LEDS_DUPLEX_FULL_P1 11
#define MSK_EPLCN_PHY_LEDS_RES2           0xfffff000U
#define SRT_EPLCN_PHY_LEDS_RES2           12

enum {
	BFW_EPLCN_PHY_LEDS_LINK_UP_P0     = 1,  /* [0] */
	BFW_EPLCN_PHY_LEDS_ACTIVITY_P0    = 1,  /* [1] */
	BFW_EPLCN_PHY_LEDS_SPEED_100_P0   = 1,  /* [2] */
	BFW_EPLCN_PHY_LEDS_DUPLEX_FULL_P0 = 1,  /* [3] */
	BFW_EPLCN_PHY_LEDS_RES1           = 4,  /* [7:4] */
	BFW_EPLCN_PHY_LEDS_LINK_UP_P1     = 1,  /* [8] */
	BFW_EPLCN_PHY_LEDS_ACTIVITY_P1    = 1,  /* [9] */
	BFW_EPLCN_PHY_LEDS_SPEED_100_P1   = 1,  /* [10] */
	BFW_EPLCN_PHY_LEDS_DUPLEX_FULL_P1 = 1,  /* [11] */
	BFW_EPLCN_PHY_LEDS_RES2           = 20  /* [31:12] */
};

typedef struct EPLCN_PHY_LEDS_BIT_Ttag {
	unsigned int LINK_UP_P0     : BFW_EPLCN_PHY_LEDS_LINK_UP_P0;     /* 1: link up, 0: link down            */
	unsigned int ACTIVITY_P0    : BFW_EPLCN_PHY_LEDS_ACTIVITY_P0;    /* 1: activity , 0: no activity        */
	unsigned int SPEED_100_P0   : BFW_EPLCN_PHY_LEDS_SPEED_100_P0;   /* 1: speed 100 MBit, 0: speed 10 MBit */
	unsigned int DUPLEX_FULL_P0 : BFW_EPLCN_PHY_LEDS_DUPLEX_FULL_P0; /* 1: full duplex, 0: half duplex      */
	unsigned int RES1           : BFW_EPLCN_PHY_LEDS_RES1;           /* res                                 */
	unsigned int LINK_UP_P1     : BFW_EPLCN_PHY_LEDS_LINK_UP_P1;     /* 1: link up, 0: link down            */
	unsigned int ACTIVITY_P1    : BFW_EPLCN_PHY_LEDS_ACTIVITY_P1;    /* 1: activity , 0: no activity        */
	unsigned int SPEED_100_P1   : BFW_EPLCN_PHY_LEDS_SPEED_100_P1;   /* 1: speed 100 MBit, 0: speed 10 MBit */
	unsigned int DUPLEX_FULL_P1 : BFW_EPLCN_PHY_LEDS_DUPLEX_FULL_P1; /* 1: full duplex, 0: half duplex      */
	unsigned int RES2           : BFW_EPLCN_PHY_LEDS_RES2;           /* res                                 */
} EPLCN_PHY_LEDS_BIT_T;

typedef union {
	unsigned int         val;
	EPLCN_PHY_LEDS_BIT_T bf;
} EPLCN_PHY_LEDS_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_SOC_RCV_SYSTIME_NS */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_SOC_RCV_SYSTIME_NS       0x000001A8U

#define MSK_EPLCN_SOC_RCV_SYSTIME_NS_VAL 0xffffffffU
#define SRT_EPLCN_SOC_RCV_SYSTIME_NS_VAL 0

enum {
	BFW_EPLCN_SOC_RCV_SYSTIME_NS_VAL = 32  /* [31:0] */
};

typedef struct EPLCN_SOC_RCV_SYSTIME_NS_BIT_Ttag {
	unsigned int VAL : BFW_EPLCN_SOC_RCV_SYSTIME_NS_VAL; /* systime_ns of last received SoC */
} EPLCN_SOC_RCV_SYSTIME_NS_BIT_T;

typedef union {
	unsigned int                   val;
	EPLCN_SOC_RCV_SYSTIME_NS_BIT_T bf;
} EPLCN_SOC_RCV_SYSTIME_NS_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_SOC_RCV_SYSTIME_S */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_SOC_RCV_SYSTIME_S       0x000001ACU

#define MSK_EPLCN_SOC_RCV_SYSTIME_S_VAL 0xffffffffU
#define SRT_EPLCN_SOC_RCV_SYSTIME_S_VAL 0

enum {
	BFW_EPLCN_SOC_RCV_SYSTIME_S_VAL = 32  /* [31:0] */
};

typedef struct EPLCN_SOC_RCV_SYSTIME_S_BIT_Ttag {
	unsigned int VAL : BFW_EPLCN_SOC_RCV_SYSTIME_S_VAL; /* systime_s of last received SoC */
} EPLCN_SOC_RCV_SYSTIME_S_BIT_T;

typedef union {
	unsigned int                  val;
	EPLCN_SOC_RCV_SYSTIME_S_BIT_T bf;
} EPLCN_SOC_RCV_SYSTIME_S_T;

/* --------------------------------------------------------------------- */
/* Register AREA_EPLCN_TRIPPLEBUF_AREA */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_AREA_EPLCN_TRIPPLEBUF_AREA       0x000001B0U

/* --------------------------------------------------------------------- */
/* Register EPLCN_SENDING_POLLRSP_EN */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_SENDING_POLLRSP_EN       0x000001B0U

#define MSK_EPLCN_SENDING_POLLRSP_EN_VAL 0x00000001U
#define SRT_EPLCN_SENDING_POLLRSP_EN_VAL 0
#define MSK_EPLCN_SENDING_POLLRSP_EN_RES 0xfffffffeU
#define SRT_EPLCN_SENDING_POLLRSP_EN_RES 1

enum {
	BFW_EPLCN_SENDING_POLLRSP_EN_VAL = 1,  /* [0] */
	BFW_EPLCN_SENDING_POLLRSP_EN_RES = 31  /* [31:1] */
};

typedef struct EPLCN_SENDING_POLLRSP_EN_BIT_Ttag {
	unsigned int VAL : BFW_EPLCN_SENDING_POLLRSP_EN_VAL; /* 1/0: transmission of Poll response enabled/disabled */
	unsigned int RES : BFW_EPLCN_SENDING_POLLRSP_EN_RES; /* reserved, shall be set to zero                      */
} EPLCN_SENDING_POLLRSP_EN_BIT_T;

typedef union {
	unsigned int                   val;
	EPLCN_SENDING_POLLRSP_EN_BIT_T bf;
} EPLCN_SENDING_POLLRSP_EN_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_TRIPBUF_POLLRSP_XPEC */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_TRIPBUF_POLLRSP_XPEC       0x000001B4U

#define MSK_EPLCN_TRIPBUF_POLLRSP_XPEC_VAL 0xffffffffU
#define SRT_EPLCN_TRIPBUF_POLLRSP_XPEC_VAL 0

enum {
	BFW_EPLCN_TRIPBUF_POLLRSP_XPEC_VAL = 32  /* [31:0] */
};

typedef struct EPLCN_TRIPBUF_POLLRSP_XPEC_BIT_Ttag {
	unsigned int VAL : BFW_EPLCN_TRIPBUF_POLLRSP_XPEC_VAL; /* xPEC register of Tripple Buffer for Poll Response */
} EPLCN_TRIPBUF_POLLRSP_XPEC_BIT_T;

typedef union {
	unsigned int                     val;
	EPLCN_TRIPBUF_POLLRSP_XPEC_BIT_T bf;
} EPLCN_TRIPBUF_POLLRSP_XPEC_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_TRIPBUF_POLLRSP_LAST */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_TRIPBUF_POLLRSP_LAST       0x000001B8U

#define MSK_EPLCN_TRIPBUF_POLLRSP_LAST_VAL 0xffffffffU
#define SRT_EPLCN_TRIPBUF_POLLRSP_LAST_VAL 0

enum {
	BFW_EPLCN_TRIPBUF_POLLRSP_LAST_VAL = 32  /* [31:0] */
};

typedef struct EPLCN_TRIPBUF_POLLRSP_LAST_BIT_Ttag {
	unsigned int VAL : BFW_EPLCN_TRIPBUF_POLLRSP_LAST_VAL; /* LAST register of Tripple Buffer for Poll Response */
} EPLCN_TRIPBUF_POLLRSP_LAST_BIT_T;

typedef union {
	unsigned int                     val;
	EPLCN_TRIPBUF_POLLRSP_LAST_BIT_T bf;
} EPLCN_TRIPBUF_POLLRSP_LAST_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_TRIPBUF_POLLRSP_ARM */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_TRIPBUF_POLLRSP_ARM       0x000001BCU

#define MSK_EPLCN_TRIPBUF_POLLRSP_ARM_VAL 0xffffffffU
#define SRT_EPLCN_TRIPBUF_POLLRSP_ARM_VAL 0

enum {
	BFW_EPLCN_TRIPBUF_POLLRSP_ARM_VAL = 32  /* [31:0] */
};

typedef struct EPLCN_TRIPBUF_POLLRSP_ARM_BIT_Ttag {
	unsigned int VAL : BFW_EPLCN_TRIPBUF_POLLRSP_ARM_VAL; /* ARM register of Tripple Buffer for Poll Response */
} EPLCN_TRIPBUF_POLLRSP_ARM_BIT_T;

typedef union {
	unsigned int                    val;
	EPLCN_TRIPBUF_POLLRSP_ARM_BIT_T bf;
} EPLCN_TRIPBUF_POLLRSP_ARM_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_TRIPBUF_POLLRSP_UPDATED */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_TRIPBUF_POLLRSP_UPDATED       0x000001C0U

#define MSK_EPLCN_TRIPBUF_POLLRSP_UPDATED_VAL 0xffffffffU
#define SRT_EPLCN_TRIPBUF_POLLRSP_UPDATED_VAL 0

enum {
	BFW_EPLCN_TRIPBUF_POLLRSP_UPDATED_VAL = 32  /* [31:0] */
};

typedef struct EPLCN_TRIPBUF_POLLRSP_UPDATED_BIT_Ttag {
	unsigned int VAL : BFW_EPLCN_TRIPBUF_POLLRSP_UPDATED_VAL; /* Updated register of Tripple Buffer for Poll Response, written by ARM, read by xPEC */
} EPLCN_TRIPBUF_POLLRSP_UPDATED_BIT_T;

typedef union {
	unsigned int                        val;
	EPLCN_TRIPBUF_POLLRSP_UPDATED_BIT_T bf;
} EPLCN_TRIPBUF_POLLRSP_UPDATED_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_SENDING_IDENTRSP_EN */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_SENDING_IDENTRSP_EN       0x000001C4U

#define MSK_EPLCN_SENDING_IDENTRSP_EN_VAL 0x00000001U
#define SRT_EPLCN_SENDING_IDENTRSP_EN_VAL 0
#define MSK_EPLCN_SENDING_IDENTRSP_EN_RES 0xfffffffeU
#define SRT_EPLCN_SENDING_IDENTRSP_EN_RES 1

enum {
	BFW_EPLCN_SENDING_IDENTRSP_EN_VAL = 1,  /* [0] */
	BFW_EPLCN_SENDING_IDENTRSP_EN_RES = 31  /* [31:1] */
};

typedef struct EPLCN_SENDING_IDENTRSP_EN_BIT_Ttag {
	unsigned int VAL : BFW_EPLCN_SENDING_IDENTRSP_EN_VAL; /* 1/0: transmission of Ident response enabled/disabled */
	unsigned int RES : BFW_EPLCN_SENDING_IDENTRSP_EN_RES; /* reserved, shall be set to zero                       */
} EPLCN_SENDING_IDENTRSP_EN_BIT_T;

typedef union {
	unsigned int                    val;
	EPLCN_SENDING_IDENTRSP_EN_BIT_T bf;
} EPLCN_SENDING_IDENTRSP_EN_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_TRIPBUF_IDENTRSP_XPEC */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_TRIPBUF_IDENTRSP_XPEC       0x000001C8U

#define MSK_EPLCN_TRIPBUF_IDENTRSP_XPEC_VAL 0xffffffffU
#define SRT_EPLCN_TRIPBUF_IDENTRSP_XPEC_VAL 0

enum {
	BFW_EPLCN_TRIPBUF_IDENTRSP_XPEC_VAL = 32  /* [31:0] */
};

typedef struct EPLCN_TRIPBUF_IDENTRSP_XPEC_BIT_Ttag {
	unsigned int VAL : BFW_EPLCN_TRIPBUF_IDENTRSP_XPEC_VAL; /* xPEC register of Tripple Buffer for Ident Response */
} EPLCN_TRIPBUF_IDENTRSP_XPEC_BIT_T;

typedef union {
	unsigned int                      val;
	EPLCN_TRIPBUF_IDENTRSP_XPEC_BIT_T bf;
} EPLCN_TRIPBUF_IDENTRSP_XPEC_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_TRIPBUF_IDENTRSP_LAST */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_TRIPBUF_IDENTRSP_LAST       0x000001CCU

#define MSK_EPLCN_TRIPBUF_IDENTRSP_LAST_VAL 0xffffffffU
#define SRT_EPLCN_TRIPBUF_IDENTRSP_LAST_VAL 0

enum {
	BFW_EPLCN_TRIPBUF_IDENTRSP_LAST_VAL = 32  /* [31:0] */
};

typedef struct EPLCN_TRIPBUF_IDENTRSP_LAST_BIT_Ttag {
	unsigned int VAL : BFW_EPLCN_TRIPBUF_IDENTRSP_LAST_VAL; /* LAST register of Tripple Buffer for Ident Response */
} EPLCN_TRIPBUF_IDENTRSP_LAST_BIT_T;

typedef union {
	unsigned int                      val;
	EPLCN_TRIPBUF_IDENTRSP_LAST_BIT_T bf;
} EPLCN_TRIPBUF_IDENTRSP_LAST_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_TRIPBUF_IDENTRSP_ARM */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_TRIPBUF_IDENTRSP_ARM       0x000001D0U

#define MSK_EPLCN_TRIPBUF_IDENTRSP_ARM_VAL 0xffffffffU
#define SRT_EPLCN_TRIPBUF_IDENTRSP_ARM_VAL 0

enum {
	BFW_EPLCN_TRIPBUF_IDENTRSP_ARM_VAL = 32  /* [31:0] */
};

typedef struct EPLCN_TRIPBUF_IDENTRSP_ARM_BIT_Ttag {
	unsigned int VAL : BFW_EPLCN_TRIPBUF_IDENTRSP_ARM_VAL; /* ARM register of Tripple Buffer for Ident Response */
} EPLCN_TRIPBUF_IDENTRSP_ARM_BIT_T;

typedef union {
	unsigned int                     val;
	EPLCN_TRIPBUF_IDENTRSP_ARM_BIT_T bf;
} EPLCN_TRIPBUF_IDENTRSP_ARM_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_TRIPBUF_IDENTRSP_UPDATED */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_TRIPBUF_IDENTRSP_UPDATED       0x000001D4U

#define MSK_EPLCN_TRIPBUF_IDENTRSP_UPDATED_VAL 0xffffffffU
#define SRT_EPLCN_TRIPBUF_IDENTRSP_UPDATED_VAL 0

enum {
	BFW_EPLCN_TRIPBUF_IDENTRSP_UPDATED_VAL = 32  /* [31:0] */
};

typedef struct EPLCN_TRIPBUF_IDENTRSP_UPDATED_BIT_Ttag {
	unsigned int VAL : BFW_EPLCN_TRIPBUF_IDENTRSP_UPDATED_VAL; /* Updated register of Tripple Buffer for Ident Response, written by ARM, read by xPEC */
} EPLCN_TRIPBUF_IDENTRSP_UPDATED_BIT_T;

typedef union {
	unsigned int                         val;
	EPLCN_TRIPBUF_IDENTRSP_UPDATED_BIT_T bf;
} EPLCN_TRIPBUF_IDENTRSP_UPDATED_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_SENDING_STATUSRSP_EN */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_SENDING_STATUSRSP_EN       0x000001D8U

#define MSK_EPLCN_SENDING_STATUSRSP_EN_VAL 0x00000001U
#define SRT_EPLCN_SENDING_STATUSRSP_EN_VAL 0
#define MSK_EPLCN_SENDING_STATUSRSP_EN_RES 0xfffffffeU
#define SRT_EPLCN_SENDING_STATUSRSP_EN_RES 1

enum {
	BFW_EPLCN_SENDING_STATUSRSP_EN_VAL = 1,  /* [0] */
	BFW_EPLCN_SENDING_STATUSRSP_EN_RES = 31  /* [31:1] */
};

typedef struct EPLCN_SENDING_STATUSRSP_EN_BIT_Ttag {
	unsigned int VAL : BFW_EPLCN_SENDING_STATUSRSP_EN_VAL; /* 1/0: transmission of Status response enabled/disabled */
	unsigned int RES : BFW_EPLCN_SENDING_STATUSRSP_EN_RES; /* reserved, shall be set to zero                        */
} EPLCN_SENDING_STATUSRSP_EN_BIT_T;

typedef union {
	unsigned int                     val;
	EPLCN_SENDING_STATUSRSP_EN_BIT_T bf;
} EPLCN_SENDING_STATUSRSP_EN_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_TRIPBUF_STATUSRSP_XPEC */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_TRIPBUF_STATUSRSP_XPEC       0x000001DCU

#define MSK_EPLCN_TRIPBUF_STATUSRSP_XPEC_VAL 0xffffffffU
#define SRT_EPLCN_TRIPBUF_STATUSRSP_XPEC_VAL 0

enum {
	BFW_EPLCN_TRIPBUF_STATUSRSP_XPEC_VAL = 32  /* [31:0] */
};

typedef struct EPLCN_TRIPBUF_STATUSRSP_XPEC_BIT_Ttag {
	unsigned int VAL : BFW_EPLCN_TRIPBUF_STATUSRSP_XPEC_VAL; /* xPEC register of Tripple Buffer for Status Response */
} EPLCN_TRIPBUF_STATUSRSP_XPEC_BIT_T;

typedef union {
	unsigned int                       val;
	EPLCN_TRIPBUF_STATUSRSP_XPEC_BIT_T bf;
} EPLCN_TRIPBUF_STATUSRSP_XPEC_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_TRIPBUF_STATUSRSP_LAST */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_TRIPBUF_STATUSRSP_LAST       0x000001E0U

#define MSK_EPLCN_TRIPBUF_STATUSRSP_LAST_VAL 0xffffffffU
#define SRT_EPLCN_TRIPBUF_STATUSRSP_LAST_VAL 0

enum {
	BFW_EPLCN_TRIPBUF_STATUSRSP_LAST_VAL = 32  /* [31:0] */
};

typedef struct EPLCN_TRIPBUF_STATUSRSP_LAST_BIT_Ttag {
	unsigned int VAL : BFW_EPLCN_TRIPBUF_STATUSRSP_LAST_VAL; /* LAST register of Tripple Buffer for Status Response */
} EPLCN_TRIPBUF_STATUSRSP_LAST_BIT_T;

typedef union {
	unsigned int                       val;
	EPLCN_TRIPBUF_STATUSRSP_LAST_BIT_T bf;
} EPLCN_TRIPBUF_STATUSRSP_LAST_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_TRIPBUF_STATUSRSP_ARM */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_TRIPBUF_STATUSRSP_ARM       0x000001E4U

#define MSK_EPLCN_TRIPBUF_STATUSRSP_ARM_VAL 0xffffffffU
#define SRT_EPLCN_TRIPBUF_STATUSRSP_ARM_VAL 0

enum {
	BFW_EPLCN_TRIPBUF_STATUSRSP_ARM_VAL = 32  /* [31:0] */
};

typedef struct EPLCN_TRIPBUF_STATUSRSP_ARM_BIT_Ttag {
	unsigned int VAL : BFW_EPLCN_TRIPBUF_STATUSRSP_ARM_VAL; /* ARM register of Tripple Buffer for Status Response */
} EPLCN_TRIPBUF_STATUSRSP_ARM_BIT_T;

typedef union {
	unsigned int                      val;
	EPLCN_TRIPBUF_STATUSRSP_ARM_BIT_T bf;
} EPLCN_TRIPBUF_STATUSRSP_ARM_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_TRIPBUF_STATUSRSP_UPDATED */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_TRIPBUF_STATUSRSP_UPDATED       0x000001E8U

#define MSK_EPLCN_TRIPBUF_STATUSRSP_UPDATED_VAL 0xffffffffU
#define SRT_EPLCN_TRIPBUF_STATUSRSP_UPDATED_VAL 0

enum {
	BFW_EPLCN_TRIPBUF_STATUSRSP_UPDATED_VAL = 32  /* [31:0] */
};

typedef struct EPLCN_TRIPBUF_STATUSRSP_UPDATED_BIT_Ttag {
	unsigned int VAL : BFW_EPLCN_TRIPBUF_STATUSRSP_UPDATED_VAL; /* Updated register of Tripple Buffer for Status Response, written by ARM, read by xPEC */
} EPLCN_TRIPBUF_STATUSRSP_UPDATED_BIT_T;

typedef union {
	unsigned int                          val;
	EPLCN_TRIPBUF_STATUSRSP_UPDATED_BIT_T bf;
} EPLCN_TRIPBUF_STATUSRSP_UPDATED_T;

/* --------------------------------------------------------------------- */
/* Register AREA_EPLCN_TXBUF1 */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_AREA_EPLCN_TXBUF1       0x000001ECU

/* --------------------------------------------------------------------- */
/* Register AREA_EPLCN_TXBUF2 */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_AREA_EPLCN_TXBUF2       0x0000020CU

/* --------------------------------------------------------------------- */
/* Register AREA_EPLCN_RX_RPU_ERROR_CODE_JUMP_TABLE_BASE */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_AREA_EPLCN_RX_RPU_ERROR_CODE_JUMP_TABLE_BASE       0x0000022CU

/* --------------------------------------------------------------------- */
/* Register AREA_EPLCN_RXBUF1 */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_AREA_EPLCN_RXBUF1       0x0000023CU

/* --------------------------------------------------------------------- */
/* Register AREA_EPLCN_RXBUF2 */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_AREA_EPLCN_RXBUF2       0x0000025CU

/* --------------------------------------------------------------------- */
/* Register AREA_EPLCN_PREQ_FILTER_TABLE */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_AREA_EPLCN_PREQ_FILTER_TABLE       0x0000027CU

/* --------------------------------------------------------------------- */
/* Register AREA_EPLCN_PRSP_FILTER_TABLE */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_AREA_EPLCN_PRSP_FILTER_TABLE       0x0000029CU

/* --------------------------------------------------------------------- */
/* Register AREA_EPLCN_ASND_FILTER_TABLE */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_AREA_EPLCN_ASND_FILTER_TABLE       0x000002BCU

/* --------------------------------------------------------------------- */
/* Register AREA_EPLCN_RX_EPL_MESSAGE_TYPE_JUMP_TABLE_BASE */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_AREA_EPLCN_RX_EPL_MESSAGE_TYPE_JUMP_TABLE_BASE       0x000002DCU

/* --------------------------------------------------------------------- */
/* Register AREA_EPLCN_RESERVED */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_AREA_EPLCN_RESERVED       0x000002ECU

/* --------------------------------------------------------------------- */
/* Register EPLCN_XPEC2ARM_INTERRUPTS */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_XPEC2ARM_INTERRUPTS       0x000002ECU

#define MSK_EPLCN_XPEC2ARM_INTERRUPTS_IND_HI            0x00000001U
#define SRT_EPLCN_XPEC2ARM_INTERRUPTS_IND_HI            0
#define MSK_EPLCN_XPEC2ARM_INTERRUPTS_IND_LO            0x00000002U
#define SRT_EPLCN_XPEC2ARM_INTERRUPTS_IND_LO            1
#define MSK_EPLCN_XPEC2ARM_INTERRUPTS_CON_HI            0x00000004U
#define SRT_EPLCN_XPEC2ARM_INTERRUPTS_CON_HI            2
#define MSK_EPLCN_XPEC2ARM_INTERRUPTS_CON_LO            0x00000008U
#define SRT_EPLCN_XPEC2ARM_INTERRUPTS_CON_LO            3
#define MSK_EPLCN_XPEC2ARM_INTERRUPTS_RES1              0x00000010U
#define SRT_EPLCN_XPEC2ARM_INTERRUPTS_RES1              4
#define MSK_EPLCN_XPEC2ARM_INTERRUPTS_COL               0x00000020U
#define SRT_EPLCN_XPEC2ARM_INTERRUPTS_COL               5
#define MSK_EPLCN_XPEC2ARM_INTERRUPTS_EPL_FRAME_DROPPED 0x00000040U
#define SRT_EPLCN_XPEC2ARM_INTERRUPTS_EPL_FRAME_DROPPED 6
#define MSK_EPLCN_XPEC2ARM_INTERRUPTS_INTERNAL_ERROR    0x00000080U
#define SRT_EPLCN_XPEC2ARM_INTERRUPTS_INTERNAL_ERROR    7
#define MSK_EPLCN_XPEC2ARM_INTERRUPTS_RES2              0x00000f00U
#define SRT_EPLCN_XPEC2ARM_INTERRUPTS_RES2              8
#define MSK_EPLCN_XPEC2ARM_INTERRUPTS_SOC_RCVD          0x00001000U
#define SRT_EPLCN_XPEC2ARM_INTERRUPTS_SOC_RCVD          12
#define MSK_EPLCN_XPEC2ARM_INTERRUPTS_PREQ_RCVD         0x00002000U
#define SRT_EPLCN_XPEC2ARM_INTERRUPTS_PREQ_RCVD         13
#define MSK_EPLCN_XPEC2ARM_INTERRUPTS_PRSP_SENT         0x00004000U
#define SRT_EPLCN_XPEC2ARM_INTERRUPTS_PRSP_SENT         14
#define MSK_EPLCN_XPEC2ARM_INTERRUPTS_SOA_RCVD          0x00008000U
#define SRT_EPLCN_XPEC2ARM_INTERRUPTS_SOA_RCVD          15
#define MSK_EPLCN_XPEC2ARM_INTERRUPTS_RES3              0xffff0000U
#define SRT_EPLCN_XPEC2ARM_INTERRUPTS_RES3              16

enum {
	BFW_EPLCN_XPEC2ARM_INTERRUPTS_IND_HI            = 1,  /* [0] */
	BFW_EPLCN_XPEC2ARM_INTERRUPTS_IND_LO            = 1,  /* [1] */
	BFW_EPLCN_XPEC2ARM_INTERRUPTS_CON_HI            = 1,  /* [2] */
	BFW_EPLCN_XPEC2ARM_INTERRUPTS_CON_LO            = 1,  /* [3] */
	BFW_EPLCN_XPEC2ARM_INTERRUPTS_RES1              = 1,  /* [4] */
	BFW_EPLCN_XPEC2ARM_INTERRUPTS_COL               = 1,  /* [5] */
	BFW_EPLCN_XPEC2ARM_INTERRUPTS_EPL_FRAME_DROPPED = 1,  /* [6] */
	BFW_EPLCN_XPEC2ARM_INTERRUPTS_INTERNAL_ERROR    = 1,  /* [7] */
	BFW_EPLCN_XPEC2ARM_INTERRUPTS_RES2              = 4,  /* [11:8] */
	BFW_EPLCN_XPEC2ARM_INTERRUPTS_SOC_RCVD          = 1,  /* [12] */
	BFW_EPLCN_XPEC2ARM_INTERRUPTS_PREQ_RCVD         = 1,  /* [13] */
	BFW_EPLCN_XPEC2ARM_INTERRUPTS_PRSP_SENT         = 1,  /* [14] */
	BFW_EPLCN_XPEC2ARM_INTERRUPTS_SOA_RCVD          = 1,  /* [15] */
	BFW_EPLCN_XPEC2ARM_INTERRUPTS_RES3              = 16  /* [31:16] */
};

typedef struct EPLCN_XPEC2ARM_INTERRUPTS_BIT_Ttag {
	unsigned int IND_HI            : BFW_EPLCN_XPEC2ARM_INTERRUPTS_IND_HI;            /* 1: indication hi event                               */
	unsigned int IND_LO            : BFW_EPLCN_XPEC2ARM_INTERRUPTS_IND_LO;            /* 1: indication lo event                               */
	unsigned int CON_HI            : BFW_EPLCN_XPEC2ARM_INTERRUPTS_CON_HI;            /* 1: confirmation hi event                             */
	unsigned int CON_LO            : BFW_EPLCN_XPEC2ARM_INTERRUPTS_CON_LO;            /* 1: confirmation lo event                             */
	unsigned int RES1              : BFW_EPLCN_XPEC2ARM_INTERRUPTS_RES1;              /* res                                                  */
	unsigned int COL               : BFW_EPLCN_XPEC2ARM_INTERRUPTS_COL;               /* 1: collision event                                   */
	unsigned int EPL_FRAME_DROPPED : BFW_EPLCN_XPEC2ARM_INTERRUPTS_EPL_FRAME_DROPPED; /* 1: EPL frame (SoC, PReq, PRsp, SoA) dropped event    */
	unsigned int INTERNAL_ERROR    : BFW_EPLCN_XPEC2ARM_INTERRUPTS_INTERNAL_ERROR;    /* 1: internal error detected, MAC needs restart        */
	unsigned int RES2              : BFW_EPLCN_XPEC2ARM_INTERRUPTS_RES2;              /* res                                                  */
	unsigned int SOC_RCVD          : BFW_EPLCN_XPEC2ARM_INTERRUPTS_SOC_RCVD;          /* 1: SoC received event                                */
	unsigned int PREQ_RCVD         : BFW_EPLCN_XPEC2ARM_INTERRUPTS_PREQ_RCVD;         /* 1: Poll request to local node address received event */
	unsigned int PRSP_SENT         : BFW_EPLCN_XPEC2ARM_INTERRUPTS_PRSP_SENT;         /* 1: Poll response sent event                          */
	unsigned int SOA_RCVD          : BFW_EPLCN_XPEC2ARM_INTERRUPTS_SOA_RCVD;          /* 1: SoA received event                                */
	unsigned int RES3              : BFW_EPLCN_XPEC2ARM_INTERRUPTS_RES3;              /* res                                                  */
} EPLCN_XPEC2ARM_INTERRUPTS_BIT_T;

typedef union {
	unsigned int                    val;
	EPLCN_XPEC2ARM_INTERRUPTS_BIT_T bf;
} EPLCN_XPEC2ARM_INTERRUPTS_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_ARM2XPEC_INTERRUPTS */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_ARM2XPEC_INTERRUPTS       0x000002F0U

#define MSK_EPLCN_ARM2XPEC_INTERRUPTS_RES1               0x0000ffffU
#define SRT_EPLCN_ARM2XPEC_INTERRUPTS_RES1               0
#define MSK_EPLCN_ARM2XPEC_INTERRUPTS_RSP_UPDATE_REQ     0x00010000U
#define SRT_EPLCN_ARM2XPEC_INTERRUPTS_RSP_UPDATE_REQ     16
#define MSK_EPLCN_ARM2XPEC_INTERRUPTS_INTERNAL_ERROR_ACK 0x00020000U
#define SRT_EPLCN_ARM2XPEC_INTERRUPTS_INTERNAL_ERROR_ACK 17
#define MSK_EPLCN_ARM2XPEC_INTERRUPTS_RES2               0x3ffc0000U
#define SRT_EPLCN_ARM2XPEC_INTERRUPTS_RES2               18
#define MSK_EPLCN_ARM2XPEC_INTERRUPTS_REQ_TYPE           0xc0000000U
#define SRT_EPLCN_ARM2XPEC_INTERRUPTS_REQ_TYPE           30

enum {
	BFW_EPLCN_ARM2XPEC_INTERRUPTS_RES1               = 16, /* [15:0] */
	BFW_EPLCN_ARM2XPEC_INTERRUPTS_RSP_UPDATE_REQ     = 1,  /* [16] */
	BFW_EPLCN_ARM2XPEC_INTERRUPTS_INTERNAL_ERROR_ACK = 1,  /* [17] */
	BFW_EPLCN_ARM2XPEC_INTERRUPTS_RES2               = 12, /* [29:18] */
	BFW_EPLCN_ARM2XPEC_INTERRUPTS_REQ_TYPE           = 2   /* [31:30] */
};

typedef struct EPLCN_ARM2XPEC_INTERRUPTS_BIT_Ttag {
	unsigned int RES1               : BFW_EPLCN_ARM2XPEC_INTERRUPTS_RES1;               /* res                                                                                                      */
	unsigned int RSP_UPDATE_REQ     : BFW_EPLCN_ARM2XPEC_INTERRUPTS_RSP_UPDATE_REQ;     /* 1: ARM requests Response Update                                                                          */
	unsigned int INTERNAL_ERROR_ACK : BFW_EPLCN_ARM2XPEC_INTERRUPTS_INTERNAL_ERROR_ACK; /* 1: internal error acknowledge                                                                            */
	unsigned int RES2               : BFW_EPLCN_ARM2XPEC_INTERRUPTS_RES2;               /* res                                                                                                      */
	unsigned int REQ_TYPE           : BFW_EPLCN_ARM2XPEC_INTERRUPTS_REQ_TYPE;           /* 0: no update request, 1: PollRsp update request, 2: IdentRsp update request, 3: StatusRsp update request */
} EPLCN_ARM2XPEC_INTERRUPTS_BIT_T;

typedef union {
	unsigned int                    val;
	EPLCN_ARM2XPEC_INTERRUPTS_BIT_T bf;
} EPLCN_ARM2XPEC_INTERRUPTS_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_FIFO_ELEMENT */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_FIFO_ELEMENT       0x000002F4U

#define MSK_EPLCN_FIFO_ELEMENT_FRAME_LEN           0x000007ffU
#define SRT_EPLCN_FIFO_ELEMENT_FRAME_LEN           0
#define MSK_EPLCN_FIFO_ELEMENT_RES1                0x00000800U
#define SRT_EPLCN_FIFO_ELEMENT_RES1                11
#define MSK_EPLCN_FIFO_ELEMENT_MULTI_REQ           0x00003000U
#define SRT_EPLCN_FIFO_ELEMENT_MULTI_REQ           12
#define MSK_EPLCN_FIFO_ELEMENT_SUPPRESS_CON        0x00004000U
#define SRT_EPLCN_FIFO_ELEMENT_SUPPRESS_CON        14
#define MSK_EPLCN_FIFO_ELEMENT_RES2                0x00008000U
#define SRT_EPLCN_FIFO_ELEMENT_RES2                15
#define MSK_EPLCN_FIFO_ELEMENT_FRAME_BUF_NUM       0x003f0000U
#define SRT_EPLCN_FIFO_ELEMENT_FRAME_BUF_NUM       16
#define MSK_EPLCN_FIFO_ELEMENT_INT_RAM_SEGMENT_NUM 0x03c00000U
#define SRT_EPLCN_FIFO_ELEMENT_INT_RAM_SEGMENT_NUM 22
#define MSK_EPLCN_FIFO_ELEMENT_RES3                0x0c000000U
#define SRT_EPLCN_FIFO_ELEMENT_RES3                26
#define MSK_EPLCN_FIFO_ELEMENT_ERROR_CODE          0xf0000000U
#define SRT_EPLCN_FIFO_ELEMENT_ERROR_CODE          28

enum {
	BFW_EPLCN_FIFO_ELEMENT_FRAME_LEN           = 11, /* [10:0] */
	BFW_EPLCN_FIFO_ELEMENT_RES1                = 1,  /* [11] */
	BFW_EPLCN_FIFO_ELEMENT_MULTI_REQ           = 2,  /* [13:12] */
	BFW_EPLCN_FIFO_ELEMENT_SUPPRESS_CON        = 1,  /* [14] */
	BFW_EPLCN_FIFO_ELEMENT_RES2                = 1,  /* [15] */
	BFW_EPLCN_FIFO_ELEMENT_FRAME_BUF_NUM       = 6,  /* [21:16] */
	BFW_EPLCN_FIFO_ELEMENT_INT_RAM_SEGMENT_NUM = 4,  /* [25:22] */
	BFW_EPLCN_FIFO_ELEMENT_RES3                = 2,  /* [27:26] */
	BFW_EPLCN_FIFO_ELEMENT_ERROR_CODE          = 4   /* [31:28] */
};

typedef struct EPLCN_FIFO_ELEMENT_BIT_Ttag {
	unsigned int FRAME_LEN           : BFW_EPLCN_FIFO_ELEMENT_FRAME_LEN;           /* frame length                                                                                                                                                                                    */
	unsigned int RES1                : BFW_EPLCN_FIFO_ELEMENT_RES1;                /* reserved, shall be set to zero                                                                                                                                                                  */
	unsigned int MULTI_REQ           : BFW_EPLCN_FIFO_ELEMENT_MULTI_REQ;           /* 1/0: frame is a multi/single request                                                                                                                                                            */
	unsigned int SUPPRESS_CON        : BFW_EPLCN_FIFO_ELEMENT_SUPPRESS_CON;        /* empty/indication pointer: shall be set to zero, request pointer: suppress confirmation 1/0: do/do not suppress confirmation, request pointer will be put into empty/con fifo after tranmsission */
	unsigned int RES2                : BFW_EPLCN_FIFO_ELEMENT_RES2;                /* reserved, shall be set to zero                                                                                                                                                                  */
	unsigned int FRAME_BUF_NUM       : BFW_EPLCN_FIFO_ELEMENT_FRAME_BUF_NUM;       /* frame buffer number                                                                                                                                                                             */
	unsigned int INT_RAM_SEGMENT_NUM : BFW_EPLCN_FIFO_ELEMENT_INT_RAM_SEGMENT_NUM; /* internal Ram segment number                                                                                                                                                                     */
	unsigned int RES3                : BFW_EPLCN_FIFO_ELEMENT_RES3;                /* reserved, shall be set to zero                                                                                                                                                                  */
	unsigned int ERROR_CODE          : BFW_EPLCN_FIFO_ELEMENT_ERROR_CODE;          /* error code                                                                                                                                                                                      */
} EPLCN_FIFO_ELEMENT_BIT_T;

typedef union {
	unsigned int             val;
	EPLCN_FIFO_ELEMENT_BIT_T bf;
} EPLCN_FIFO_ELEMENT_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_HELP */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_HELP       0x000002F8U

#define MSK_EPLCN_HELP_RX_BUF_ACTIVE               0x00000001U
#define SRT_EPLCN_HELP_RX_BUF_ACTIVE               0
#define MSK_EPLCN_HELP_RX_ACTUAL_ACTIVE_PORT       0x00000002U
#define SRT_EPLCN_HELP_RX_ACTUAL_ACTIVE_PORT       1
#define MSK_EPLCN_HELP_RX_DROP_FRAME               0x00000004U
#define SRT_EPLCN_HELP_RX_DROP_FRAME               2
#define MSK_EPLCN_HELP_RX_RECEIVING_ACTIVE         0x00000008U
#define SRT_EPLCN_HELP_RX_RECEIVING_ACTIVE         3
#define MSK_EPLCN_HELP_RX_FRWD_FRAME_TO_LOCAL_PORT 0x00000010U
#define SRT_EPLCN_HELP_RX_FRWD_FRAME_TO_LOCAL_PORT 4
#define MSK_EPLCN_HELP_RX_EPL_FRAME                0x00000020U
#define SRT_EPLCN_HELP_RX_EPL_FRAME                5
#define MSK_EPLCN_HELP_RES1                        0x0000ffc0U
#define SRT_EPLCN_HELP_RES1                        6
#define MSK_EPLCN_HELP_TX_BUF_TRANSFERS_TO_UTX     0x00010000U
#define SRT_EPLCN_HELP_TX_BUF_TRANSFERS_TO_UTX     16
#define MSK_EPLCN_HELP_TX_BUF_FILLED_VIA_DMA       0x00020000U
#define SRT_EPLCN_HELP_TX_BUF_FILLED_VIA_DMA       17
#define MSK_EPLCN_HELP_TX_LAST                     0x00040000U
#define SRT_EPLCN_HELP_TX_LAST                     18
#define MSK_EPLCN_HELP_TX_TRANSMITTING_ACTIVE      0x00080000U
#define SRT_EPLCN_HELP_TX_TRANSMITTING_ACTIVE      19
#define MSK_EPLCN_HELP_TX_REQ_PRIORITY             0x00100000U
#define SRT_EPLCN_HELP_TX_REQ_PRIORITY             20
#define MSK_EPLCN_HELP_TX_PRES_PENDING             0x00200000U
#define SRT_EPLCN_HELP_TX_PRES_PENDING             21
#define MSK_EPLCN_HELP_TX_SUPPRESS_CON             0x00400000U
#define SRT_EPLCN_HELP_TX_SUPPRESS_CON             22
#define MSK_EPLCN_HELP_RES2                        0x00800000U
#define SRT_EPLCN_HELP_RES2                        23
#define MSK_EPLCN_HELP_CUR_REQ_PRES                0x01000000U
#define SRT_EPLCN_HELP_CUR_REQ_PRES                24
#define MSK_EPLCN_HELP_CUR_REQ_NMT_RSP             0x02000000U
#define SRT_EPLCN_HELP_CUR_REQ_NMT_RSP             25
#define MSK_EPLCN_HELP_CUR_REQ_STATUS_RSP          0x04000000U
#define SRT_EPLCN_HELP_CUR_REQ_STATUS_RSP          26
#define MSK_EPLCN_HELP_CUR_REQ_IDENT_RSP           0x08000000U
#define SRT_EPLCN_HELP_CUR_REQ_IDENT_RSP           27
#define MSK_EPLCN_HELP_CUR_REQ_ASND                0x10000000U
#define SRT_EPLCN_HELP_CUR_REQ_ASND                28
#define MSK_EPLCN_HELP_RES3                        0xe0000000U
#define SRT_EPLCN_HELP_RES3                        29

enum {
	BFW_EPLCN_HELP_RX_BUF_ACTIVE               = 1,  /* [0] */
	BFW_EPLCN_HELP_RX_ACTUAL_ACTIVE_PORT       = 1,  /* [1] */
	BFW_EPLCN_HELP_RX_DROP_FRAME               = 1,  /* [2] */
	BFW_EPLCN_HELP_RX_RECEIVING_ACTIVE         = 1,  /* [3] */
	BFW_EPLCN_HELP_RX_FRWD_FRAME_TO_LOCAL_PORT = 1,  /* [4] */
	BFW_EPLCN_HELP_RX_EPL_FRAME                = 1,  /* [5] */
	BFW_EPLCN_HELP_RES1                        = 10, /* [15:6] */
	BFW_EPLCN_HELP_TX_BUF_TRANSFERS_TO_UTX     = 1,  /* [16] */
	BFW_EPLCN_HELP_TX_BUF_FILLED_VIA_DMA       = 1,  /* [17] */
	BFW_EPLCN_HELP_TX_LAST                     = 1,  /* [18] */
	BFW_EPLCN_HELP_TX_TRANSMITTING_ACTIVE      = 1,  /* [19] */
	BFW_EPLCN_HELP_TX_REQ_PRIORITY             = 1,  /* [20] */
	BFW_EPLCN_HELP_TX_PRES_PENDING             = 1,  /* [21] */
	BFW_EPLCN_HELP_TX_SUPPRESS_CON             = 1,  /* [22] */
	BFW_EPLCN_HELP_RES2                        = 1,  /* [23] */
	BFW_EPLCN_HELP_CUR_REQ_PRES                = 1,  /* [24] */
	BFW_EPLCN_HELP_CUR_REQ_NMT_RSP             = 1,  /* [25] */
	BFW_EPLCN_HELP_CUR_REQ_STATUS_RSP          = 1,  /* [26] */
	BFW_EPLCN_HELP_CUR_REQ_IDENT_RSP           = 1,  /* [27] */
	BFW_EPLCN_HELP_CUR_REQ_ASND                = 1,  /* [28] */
	BFW_EPLCN_HELP_RES3                        = 3   /* [31:29] */
};

typedef struct EPLCN_HELP_BIT_Ttag {
	unsigned int RX_BUF_ACTIVE               : BFW_EPLCN_HELP_RX_BUF_ACTIVE;               /* 1/0: receive buffer 1/0 is active                             */
	unsigned int RX_ACTUAL_ACTIVE_PORT       : BFW_EPLCN_HELP_RX_ACTUAL_ACTIVE_PORT;       /* 1/0: receive port 1/0 is active                               */
	unsigned int RX_DROP_FRAME               : BFW_EPLCN_HELP_RX_DROP_FRAME;               /* 1/0: received frame shall be dropped/not dropped              */
	unsigned int RX_RECEIVING_ACTIVE         : BFW_EPLCN_HELP_RX_RECEIVING_ACTIVE;         /* 1/0: receiving is active/not active                           */
	unsigned int RX_FRWD_FRAME_TO_LOCAL_PORT : BFW_EPLCN_HELP_RX_FRWD_FRAME_TO_LOCAL_PORT; /* 1/0: frame shall be forwarded to local port                   */
	unsigned int RX_EPL_FRAME                : BFW_EPLCN_HELP_RX_EPL_FRAME;                /* 1/0: epl/non_epl frame                                        */
	unsigned int RES1                        : BFW_EPLCN_HELP_RES1;                        /* res                                                           */
	unsigned int TX_BUF_TRANSFERS_TO_UTX     : BFW_EPLCN_HELP_TX_BUF_TRANSFERS_TO_UTX;     /* 1/0: transmit buffer 1/0 transfers to utx                     */
	unsigned int TX_BUF_FILLED_VIA_DMA       : BFW_EPLCN_HELP_TX_BUF_FILLED_VIA_DMA;       /* 1/0: buffer 1/0 is filled via dma                             */
	unsigned int TX_LAST                     : BFW_EPLCN_HELP_TX_LAST;                     /* 1/0: tranmission to buffers is done/not done                  */
	unsigned int TX_TRANSMITTING_ACTIVE      : BFW_EPLCN_HELP_TX_TRANSMITTING_ACTIVE;      /* 1/0: tranmission is active/not active                         */
	unsigned int TX_REQ_PRIORITY             : BFW_EPLCN_HELP_TX_REQ_PRIORITY;             /* 1/0: request priority is high/low                             */
	unsigned int TX_PRES_PENDING             : BFW_EPLCN_HELP_TX_PRES_PENDING;             /* 1/0: EPL Poll Response pending                                */
	unsigned int TX_SUPPRESS_CON             : BFW_EPLCN_HELP_TX_SUPPRESS_CON;             /* 1/0: suppress/do not suppress confirmation of current request */
	unsigned int RES2                        : BFW_EPLCN_HELP_RES2;                        /* res                                                           */
	unsigned int CUR_REQ_PRES                : BFW_EPLCN_HELP_CUR_REQ_PRES;                /* 1/0: current request is a EPL Poll Response                   */
	unsigned int CUR_REQ_NMT_RSP             : BFW_EPLCN_HELP_CUR_REQ_NMT_RSP;             /* 1/0: current request is a EPL NMT Response                    */
	unsigned int CUR_REQ_STATUS_RSP          : BFW_EPLCN_HELP_CUR_REQ_STATUS_RSP;          /* 1/0: current request is a EPL Status Response frame           */
	unsigned int CUR_REQ_IDENT_RSP           : BFW_EPLCN_HELP_CUR_REQ_IDENT_RSP;           /* 1/0: current request is a EPL Ident Response frame            */
	unsigned int CUR_REQ_ASND                : BFW_EPLCN_HELP_CUR_REQ_ASND;                /* 1/0: current request is a EPL ASnd frame                      */
	unsigned int RES3                        : BFW_EPLCN_HELP_RES3;                        /* res                                                           */
} EPLCN_HELP_BIT_T;

typedef union {
	unsigned int     val;
	EPLCN_HELP_BIT_T bf;
} EPLCN_HELP_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_SR_CONFIG */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_SR_CONFIG       0x000002FCU

#define MSK_EPLCN_SR_CONFIG_RES1                    0x000007ffU
#define SRT_EPLCN_SR_CONFIG_RES1                    0
#define MSK_EPLCN_SR_CONFIG_ERROR_CODE              0x00003800U
#define SRT_EPLCN_SR_CONFIG_ERROR_CODE              11
#define MSK_EPLCN_SR_CONFIG_REAL_SENDING_TIME_VALID 0x00004000U
#define SRT_EPLCN_SR_CONFIG_REAL_SENDING_TIME_VALID 14
#define MSK_EPLCN_SR_CONFIG_START_TRANSMIT          0x00008000U
#define SRT_EPLCN_SR_CONFIG_START_TRANSMIT          15
#define MSK_EPLCN_SR_CONFIG_RES2                    0xffff0000U
#define SRT_EPLCN_SR_CONFIG_RES2                    16

enum {
	BFW_EPLCN_SR_CONFIG_RES1                    = 11, /* [10:0] */
	BFW_EPLCN_SR_CONFIG_ERROR_CODE              = 3,  /* [13:11] */
	BFW_EPLCN_SR_CONFIG_REAL_SENDING_TIME_VALID = 1,  /* [14] */
	BFW_EPLCN_SR_CONFIG_START_TRANSMIT          = 1,  /* [15] */
	BFW_EPLCN_SR_CONFIG_RES2                    = 16  /* [31:16] */
};

typedef struct EPLCN_SR_CONFIG_BIT_Ttag {
	unsigned int RES1                    : BFW_EPLCN_SR_CONFIG_RES1;                    /* res                                 */
	unsigned int ERROR_CODE              : BFW_EPLCN_SR_CONFIG_ERROR_CODE;              /* error code at transmission          */
	unsigned int REAL_SENDING_TIME_VALID : BFW_EPLCN_SR_CONFIG_REAL_SENDING_TIME_VALID; /* 1: real transmit timestamp is valid */
	unsigned int START_TRANSMIT          : BFW_EPLCN_SR_CONFIG_START_TRANSMIT;          /* start transmit                      */
	unsigned int RES2                    : BFW_EPLCN_SR_CONFIG_RES2;                    /* res                                 */
} EPLCN_SR_CONFIG_BIT_T;

typedef union {
	unsigned int          val;
	EPLCN_SR_CONFIG_BIT_T bf;
} EPLCN_SR_CONFIG_T;

/* --------------------------------------------------------------------- */
/* Register EPLCN_SR_STATUS */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_EPLCN_SR_STATUS       0x00000300U

#define MSK_EPLCN_SR_STATUS_RECEIVED_LEN        0x000007ffU
#define SRT_EPLCN_SR_STATUS_RECEIVED_LEN        0
#define MSK_EPLCN_SR_STATUS_ERROR_CODE          0x00003800U
#define SRT_EPLCN_SR_STATUS_ERROR_CODE          11
#define MSK_EPLCN_SR_STATUS_PREAMBLE_NIB_NOT_16 0x00004000U
#define SRT_EPLCN_SR_STATUS_PREAMBLE_NIB_NOT_16 14
#define MSK_EPLCN_SR_STATUS_FRAME_FIN           0x00008000U
#define SRT_EPLCN_SR_STATUS_FRAME_FIN           15
#define MSK_EPLCN_SR_STATUS_RES2                0xffff0000U
#define SRT_EPLCN_SR_STATUS_RES2                16

enum {
	BFW_EPLCN_SR_STATUS_RECEIVED_LEN        = 11, /* [10:0] */
	BFW_EPLCN_SR_STATUS_ERROR_CODE          = 3,  /* [13:11] */
	BFW_EPLCN_SR_STATUS_PREAMBLE_NIB_NOT_16 = 1,  /* [14] */
	BFW_EPLCN_SR_STATUS_FRAME_FIN           = 1,  /* [15] */
	BFW_EPLCN_SR_STATUS_RES2                = 16  /* [31:16] */
};

typedef struct EPLCN_SR_STATUS_BIT_Ttag {
	unsigned int RECEIVED_LEN        : BFW_EPLCN_SR_STATUS_RECEIVED_LEN;        /* received frame length                        */
	unsigned int ERROR_CODE          : BFW_EPLCN_SR_STATUS_ERROR_CODE;          /* error code at reception                      */
	unsigned int PREAMBLE_NIB_NOT_16 : BFW_EPLCN_SR_STATUS_PREAMBLE_NIB_NOT_16; /* info that preamble length was not 16 nibbles */
	unsigned int FRAME_FIN           : BFW_EPLCN_SR_STATUS_FRAME_FIN;           /* reception finished                           */
	unsigned int RES2                : BFW_EPLCN_SR_STATUS_RES2;                /* res                                          */
} EPLCN_SR_STATUS_BIT_T;

typedef union {
	unsigned int          val;
	EPLCN_SR_STATUS_BIT_T bf;
} EPLCN_SR_STATUS_T;



#endif

#ifndef __eplcn_struct_h
#define __eplcn_struct_h

typedef struct EPLCN_TXAREABASE_Ttag
{
  volatile unsigned long ulEPLCN_TX_POINTER_ACTUAL;
  volatile unsigned long ulEPLCN_TX_BYTES_LEFT_FOR_UTX;
  volatile unsigned long ulEPLCN_TX_BYTES_LEFT_FOR_DMA;
  volatile unsigned long ulEPLCN_TX_RETRY;
  volatile unsigned long ulEPLCN_TX_BACKOFF_DELAY;
} EPLCN_TXAREABASE_T;

typedef struct EPLCN_RXAREABASE_Ttag
{
  volatile unsigned long ulEPLCN_RX_DST_MAC_ADDRESS_LO;
  volatile unsigned long ulEPLCN_RX_DST_MAC_ADDRESS_HI;
  volatile unsigned long ulEPLCN_RX_SRC_MAC_ADDRESS_LO;
  volatile unsigned long ulEPLCN_RX_SRC_MAC_ADDRESS_HI;
  volatile unsigned long ulEPLCN_RX_ETH_LT;
  volatile unsigned long ulEPLCN_RX_EPL_FRAME_MESSAGE_TYPE;
  volatile unsigned long ulEPLCN_RX_EPL_FRAME_DST;
  volatile unsigned long ulEPLCN_RX_EPL_FRAME_SRC;
  volatile unsigned long ulEPLCN_RX_TIMESTAMP_NS;
  volatile unsigned long ulEPLCN_RX_TIMESTAMP_S;
  volatile unsigned long ulEPLCN_RX_POINTER_ACTUAL;
  volatile unsigned long ulEPLCN_RX_WORKING;
  volatile unsigned long ulEPLCN_RX_FRAME_FIN_OK_EPL_JUMP_LABEL;
  volatile unsigned long ulEPLCN_DMA0_CFG;
  volatile unsigned long ulEPLCN_DMA1_CFG;
  volatile unsigned long ulEPLCN_FLASH_FREQ_OF_LINK_ACT_TEMP;
} EPLCN_RXAREABASE_T;

typedef struct EPLCN_CONFIG_AREA_BASE_Ttag
{
  volatile unsigned long ulEPLCN_GEN_SOC_RCVD_TRIGGER_OE;
  volatile unsigned long ulEPLCN_GEN_SOC_RCVD_TRIGGER_POLARITY;
  volatile unsigned long ulEPLCN_SOC_TRIGGER_DELAY;
  volatile unsigned long ulEPLCN_SOC_TRIGGER_LENGTH;
  volatile unsigned long ulEPLCN_FLASH_FREQ_OF_LINK_ACT_LED;
  volatile unsigned long ulEPLCN_COL_LED_EN;
  volatile unsigned long ulEPLCN_FLASH_FREQ_OF_COL_LED;
  volatile unsigned long ulEPLCN_INTERRUPTS_ENABLE_IND_HI;
  volatile unsigned long ulEPLCN_INTERRUPTS_ENABLE_IND_LO;
  volatile unsigned long ulEPLCN_INTERRUPTS_ENABLE_CON_HI;
  volatile unsigned long ulEPLCN_INTERRUPTS_ENABLE_CON_LO;
  volatile unsigned long ulEPLCN_INTERRUPTS_ENABLE_COL;
  volatile unsigned long ulEPLCN_INTERRUPTS_ENABLE_EPL_FRAME_DROPPED;
  volatile unsigned long ulEPLCN_INTERRUPTS_ENABLE_INTERNAL_ERROR;
  volatile unsigned long ulEPLCN_INTERRUPTS_ENABLE_SOC_RCVD;
  volatile unsigned long ulEPLCN_INTERRUPTS_ENABLE_PREQ_RCVD;
  volatile unsigned long ulEPLCN_INTERRUPTS_ENABLE_PRSP_SENT;
  volatile unsigned long ulEPLCN_INTERRUPTS_ENABLE_SOA_RCVD;
  volatile unsigned long ulEPLCN_LOCAL_MAC_ADDRESS_LO;
  volatile unsigned long ulEPLCN_LOCAL_MAC_ADDRESS_HI;
  volatile unsigned long ulEPLCN_EPL_NODE_ID;
  volatile unsigned long ulEPLCN_REQ_FIFOS_LOCKED;
  volatile unsigned long ulEPLCN_SYSTIME_BORDER_COPY;
} EPLCN_CONFIG_AREA_BASE_T;

typedef struct EPLCN_STATUS_AREA_BASE_Ttag
{
  volatile unsigned long ulEPLCN_FRAMES_TRANSMITTED_OK;
  volatile unsigned long ulEPLCN_SINGLE_COLLISION_FRAMES;
  volatile unsigned long ulEPLCN_MULTIPLE_COLLISION_FRAMES;
  volatile unsigned long ulEPLCN_COLLISIONS_DURING_EPL_MODE;
  volatile unsigned long ulEPLCN_PRES_TRANSMITTED_OK;
  volatile unsigned long ulEPLCN_NMT_RSP_TRANSMITTED_OK;
  volatile unsigned long ulEPLCN_STATUS_RSP_TRANSMITTED_OK;
  volatile unsigned long ulEPLCN_IDENT_RSP_TRANSMITTED_OK;
  volatile unsigned long ulEPLCN_ASND_TRANSMITTED_OK;
  volatile unsigned long ulEPLCN_UNKNOWN_EPL_FRAME_TRANSMITTED_OK;
  volatile unsigned long ulEPLCN_UTX0_2FREE_UTX1_FULL;
  volatile unsigned long ulEPLCN_COLLISIONS_PRES;
  volatile unsigned long ulEPLCN_COLLISIONS_NMT_RSP;
  volatile unsigned long ulEPLCN_COLLISIONS_STATUS_RSP;
  volatile unsigned long ulEPLCN_COLLISIONS_IDENT_RSP;
  volatile unsigned long ulEPLCN_COLLISIONS_ASND;
  volatile unsigned long ulEPLCN_COLLISIONS_UNKNOWN_EPL_FRAME;
  volatile unsigned long ulEPLCN_FRAMES_RECEIVED_OK;
  volatile unsigned long ulEPLCN_FRAME_CHECK_SEQUENCE_ERRORS;
  volatile unsigned long ulEPLCN_ALIGNMENT_ERRORS;
  volatile unsigned long ulEPLCN_FRAME_TOO_LONG_ERRORS;
  volatile unsigned long ulEPLCN_COLLISION_FRAGMENTS_RECEIVED;
  volatile unsigned long ulEPLCN_FRAMES_DROPPED_DUE_LOW_RESOURCE_EPL;
  volatile unsigned long ulEPLCN_FRAMES_DROPPED_DUE_LOW_RESOURCE_NON_EPL;
  volatile unsigned long ulEPLCN_FRAME_PREAMBLE_NIB_LEN_NOT_16_P0;
  volatile unsigned long ulEPLCN_FRAME_PREAMBLE_NIB_LEN_NOT_16_P1;
  volatile unsigned long ulEPLCN_FRAME_RCVD_OK_WITH_DRIBNIB_AND_FCS_OK;
  volatile unsigned long ulEPLCN_SOC_DETECTED;
  volatile unsigned long ulEPLCN_POLLREQ_FOR_LOCAL_NODE_DETECTED;
  volatile unsigned long ulEPLCN_POLLREQ_FOR_REMOTE_NODE_DETECTED;
  volatile unsigned long ulEPLCN_POLLRES_OF_REMOTE_NODE_DETECTED;
  volatile unsigned long ulEPLCN_SOA_TO_REMOTE_NODE_DETECTED;
  volatile unsigned long ulEPLCN_SOA_NO_SERVICE_DETECTED;
  volatile unsigned long ulEPLCN_SOA_IDENT_REQ_DETECTED;
  volatile unsigned long ulEPLCN_SOA_STATUS_REQ_DETECTED;
  volatile unsigned long ulEPLCN_SOA_NMT_REQUEST_INVITE_DETECTED;
  volatile unsigned long ulEPLCN_SOA_UNSPECIFIED_INVITE_DETECTED;
  volatile unsigned long ulEPLCN_SOA_LOCAL_NODE_UNKNOWN_SERVICE_DETECTED;
  volatile unsigned long ulEPLCN_ASND_DETECTED;
  volatile unsigned long ulEPLCN_UNKNOWN_EPL_MSG_TYPE_DETECTED;
  volatile unsigned long ulEPLCN_SOC_RECEIVED_OK;
  volatile unsigned long ulEPLCN_POLLREQ_FOR_LOCAL_NODE_RECEIVED_OK;
  volatile unsigned long ulEPLCN_POLLREQ_FOR_REMOTE_NODE_RECEIVED_OK;
  volatile unsigned long ulEPLCN_POLLREQ_FOR_REMOTE_NODE_FILTERED;
  volatile unsigned long ulEPLCN_POLLRES_OF_REMOTE_NODE_RECEIVED_OK;
  volatile unsigned long ulEPLCN_POLLRES_OF_REMOTE_NODE_FILTERED;
  volatile unsigned long ulEPLCN_SOA_NO_SERVICE_RECEIVED_OK;
  volatile unsigned long ulEPLCN_SOA_IDENT_REQ_RECEIVED_OK;
  volatile unsigned long ulEPLCN_SOA_STATUS_REQ_RECEIVED_OK;
  volatile unsigned long ulEPLCN_SOA_NMT_REQUEST_INVITE_RECEIVED_OK;
  volatile unsigned long ulEPLCN_SOA_UNSPECIFIED_INVITE_RECEIVED_OK;
  volatile unsigned long ulEPLCN_SOA_UNKNOWN_SERVICE_RECEIVED_OK;
  volatile unsigned long ulEPLCN_SOA_REMOTE_NODE_RECEIVED_OK;
  volatile unsigned long ulEPLCN_ASND_RECEIVED_OK;
  volatile unsigned long ulEPLCN_ASND_FILTERED;
  volatile unsigned long ulEPLCN_UNKNOWN_EPL_MSG_TYPE_RECEIVED_OK;
  volatile unsigned long ulEPLCN_RX_FRAME_FIN_SET_OUTSIDE_RX_FLOW_P0;
  volatile unsigned long ulEPLCN_RX_FRAME_FIN_SET_OUTSIDE_RX_FLOW_P1;
  volatile unsigned long ulEPLCN_RX_FATAL_ERROR;
  volatile unsigned long ulEPLCN_EPL_NODE_STATUS;
  volatile unsigned long ulEPLCN_PHY_LEDS;
  volatile unsigned long ulEPLCN_SOC_RCV_SYSTIME_NS;
  volatile unsigned long ulEPLCN_SOC_RCV_SYSTIME_S;
} EPLCN_STATUS_AREA_BASE_T;

typedef struct EPLCN_TRIPPLEBUF_AREA_Ttag
{
  volatile unsigned long ulEPLCN_SENDING_POLLRSP_EN;
  volatile unsigned long ulEPLCN_TRIPBUF_POLLRSP_XPEC;
  volatile unsigned long ulEPLCN_TRIPBUF_POLLRSP_LAST;
  volatile unsigned long ulEPLCN_TRIPBUF_POLLRSP_ARM;
  volatile unsigned long ulEPLCN_TRIPBUF_POLLRSP_UPDATED;
  volatile unsigned long ulEPLCN_SENDING_IDENTRSP_EN;
  volatile unsigned long ulEPLCN_TRIPBUF_IDENTRSP_XPEC;
  volatile unsigned long ulEPLCN_TRIPBUF_IDENTRSP_LAST;
  volatile unsigned long ulEPLCN_TRIPBUF_IDENTRSP_ARM;
  volatile unsigned long ulEPLCN_TRIPBUF_IDENTRSP_UPDATED;
  volatile unsigned long ulEPLCN_SENDING_STATUSRSP_EN;
  volatile unsigned long ulEPLCN_TRIPBUF_STATUSRSP_XPEC;
  volatile unsigned long ulEPLCN_TRIPBUF_STATUSRSP_LAST;
  volatile unsigned long ulEPLCN_TRIPBUF_STATUSRSP_ARM;
  volatile unsigned long ulEPLCN_TRIPBUF_STATUSRSP_UPDATED;
} EPLCN_TRIPPLEBUF_AREA_T;

typedef struct EPLCN_RESERVED_Ttag
{
  volatile unsigned long ulEPLCN_XPEC2ARM_INTERRUPTS;
  volatile unsigned long ulEPLCN_ARM2XPEC_INTERRUPTS;
  volatile unsigned long ulEPLCN_FIFO_ELEMENT;
  volatile unsigned long ulEPLCN_HELP;
  volatile unsigned long ulEPLCN_SR_CONFIG;
  volatile unsigned long ulEPLCN_SR_STATUS;
} EPLCN_RESERVED_T;

/* combined 16 structures */
typedef struct EPL_CN_XPEC_DPMtag {
  volatile unsigned long aulEPLCN_XPEC_PROGRAM[1];
  EPLCN_TXAREABASE_T tEPLCN_TXAREABASE;
  EPLCN_RXAREABASE_T tEPLCN_RXAREABASE;
  EPLCN_CONFIG_AREA_BASE_T tEPLCN_CONFIG_AREA_BASE;
  EPLCN_STATUS_AREA_BASE_T tEPLCN_STATUS_AREA_BASE;
  EPLCN_TRIPPLEBUF_AREA_T tEPLCN_TRIPPLEBUF_AREA;
  volatile unsigned long aulEPLCN_TXBUF1[8];
  volatile unsigned long aulEPLCN_TXBUF2[8];
  volatile unsigned long aulEPLCN_RX_RPU_ERROR_CODE_JUMP_TABLE_BASE[4];
  volatile unsigned long aulEPLCN_RXBUF1[8];
  volatile unsigned long aulEPLCN_RXBUF2[8];
  volatile unsigned long aulEPLCN_PREQ_FILTER_TABLE[8];
  volatile unsigned long aulEPLCN_PRSP_FILTER_TABLE[8];
  volatile unsigned long aulEPLCN_ASND_FILTER_TABLE[8];
  volatile unsigned long aulEPLCN_RX_EPL_MESSAGE_TYPE_JUMP_TABLE_BASE[4];
} EPL_CN_XPEC_DPM;

#endif /* __eplcn_struct_h */
